#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"

#include "liqcamera.h"


#include "mk_core.h"









static int runfast=0;

static liqtile *tileroot=NULL;
static liqtile *tilepostcard=NULL;
static liqtile *tilesend=NULL;


static char *selecteditem=NULL;

static liqimage * imgcam=NULL;

static liqstyle * stylecam=NULL;




static int xitem_click(struct liqtile *self)
{
//
}






static int tilepostcard_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	//// ok, the screen is about to be painted.
	//// set runfast to 0 - this ensures it does not remain fast unless we need it to be so :)
	//runfast=0;
	// now, render as normal
	//self->handlerpaint=NULL;
	//liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	//self->handlerpaint=tileroot_paint;
	
	// as long as the mouse is within the boundary of this i should be drawing on it
	
	
}







static int tileroot_paint(struct liqtile *self,liqtileeventpaint *args)
{
	//// ok, the screen is about to be painted.
	//// set runfast to 0 - this ensures it does not remain fast unless we need it to be so :)
	//runfast=0;
	// now, render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=tileroot_paint;
}



static int tool_send_click(struct liqtile *self)
{


				{
					int result=liqdialog_ask("uploaded to server now :)","your postcard will be delivered shortly",NULL,NULL,1,
					   		"OK",
					   		NULL);

				//	if(result==-1) {    return -1;                         } // Cancelled, Do Nothing
				}
				
				return 0;

}





int liqintroduction_run()
{
	
	runfast=1;//0;

	// lets go
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}


//#define CAMW 640
//#define CAMH 480
#define CAMW 320
#define CAMH 240
//#define CAMW 160
//#define CAMH 120

	//if(usecamera)
	{

		imgcam=liqimage_create();
		liqimage_pagedefine(imgcam,CAMW,CAMH,canvas.dpix,canvas.dpiy,0);
			cliprect cr;
			cliprect_initfromimage(&cr,imgcam);
			cliprect_drawclear(&cr,0,128,128);
			cliprect_drawtextinside(&cr,canvas.font,0,0,imgcam->width,imgcam->height,"Please wait",1);
		
		liqcamera_start(CAMW,CAMH,8,    imgcam,NULL);
	}
	
	stylecam=liqstyle_create();
	stylecam->backmode=1;
	stylecam->backimage=imgcam;
	liqstyle_setbackcoloryuv(stylecam,255,0,0);
	//back->borderwidth=1200;
	stylecam->borderwidth=00;
	liqstyle_setbordercoloryuv(stylecam,255,128,255);
	stylecam->textfont=NULL;//canvas.font;
	stylecam->textalignx=1;
	
	
	
	
	canvas_clear(0);

	//styleback->backmode=2;
	
		tileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
		//tileroot->handlermouse=page_drawstroke_mouse;
		tileroot->handlerpaint=tileroot_paint;
		tileroot->style=styleblack;	


			//liqtile_childappend(tileroot, usingstyle( stylecolorpalette,   at(40  ,40  , mklabelwh("picture"    , 320,200))   )   );
			liqtile_childappend(tileroot, usingstyle( stylecam,            at(40  ,40  , mklabelwh("picture"    , 320,240))   )   );
			liqtile_childappend(tileroot, usingstyle( stylebuttonsel,      at(40  ,300 , mklabelwh(   "livefeed"   , 160,80)) )   );
			liqtile_childappend(tileroot, usingstyle( stylebutton,         at(200 ,300 , mklabelwh(   "takepicture", 160,80)) )   );


tilepostcard = liqtile_childappend(tileroot, usingstyle( styletext,        at(360,0 , mklabelwh("send me a postcard",  440,40 ))  )  );
tilepostcard->handlermouse=tilepostcard_mouse;

			liqtile_childappend(tileroot, usingstyle( stylegrid,           at(360,40 , mklabelwh("",    440,400 ))  )  );
			//liqtile_childappend(tileroot, usingstyle( styletext,         at(440,180, mklabelwh("role",    320,120 ))  )  );
			//liqtile_childappend(tileroot, usingstyle( styletext,         at(440,320, mklabelwh("email",   320,120 ))  )  );

tilesend =	liqtile_childappend(tileroot, usingstyle( stylebutton,         at(440,440 , mklabelwh("send now!",    440,40 ))  )  );
tilesend->handlerclick = tool_send_click;


		liqtile_easyrun2(tileroot,&runfast);
		
		
		liqtile_close(tileroot);


	//if(usecamera)
	{
		liqcamera_stop();
	}
	liqimage_free(imgcam);
	imgcam=NULL;
	
	
	liqstyle_close(stylecam);
	
	
	mk_style_close();
}







