#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>









#include "liqapp.h"
#include "liqdraw.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "liqtile.h"
#include "liqtextbuffer.h"


#include "mk_core.h"

int isinternetsketch=0;




int mksketch_run(PAGE *basepage);

int mkproject_run();

int mkfileselect_run();


static int runfast=0;

/*
static liqstyle *styleback=NULL;
static liqstyle *stylegrid=NULL;
static liqstyle *stylenone=NULL;
static liqstyle *styleknob=NULL;
static liqstyle *stylelabel=NULL;
static liqstyle *stylelabelsel=NULL;
static liqstyle *stylecolorbright=NULL;
static liqstyle *stylecolorpalette=NULL;
static liqstyle *stylepencolor=NULL;
 */

static liqtile *tilecurr=NULL;
//static liqtile *tilepicgrid=NULL;
//static liqtile *tilecurrtitle=NULL;
//static liqtile *tilemenu=NULL;
static liqtile *tileroot=NULL;
static liqtile *tilepage=NULL;
static liqtile *tiletools=NULL;

// ui is simply tileroot.pageview
// i just assign the correct handler to the data
// inside tileroot.pageview i have a selection tile
// this is invisible initially
// it contains a set of hotspots for resizing automagically :)
// the page is simply a whole page page like I am used to handling
// the ui can come and go as i want it to
//

static PAGE *   page=NULL;
static STROKE * strokecurr=NULL;
static void stroke_render(STROKE *sa,int flagshowall);




static int strokesdrawn=0;			// count of strokes drawn since clearing or reverting :)





static void save_now()
{
	if(page==NULL) return;
	if(page->strokecount==0) return;
	if(strokesdrawn==0) return;
	
	char 		fmtnow[255];
	 			app_formatnow(fmtnow,255,"yyyymmdd_hhmmss");

	//char        key[255];

	char 		filename[255];
	
	
	// allow data to evolve.
	// 
	
	
	
	//if(titlebuffer.bufferlen==0)
	{
	//	snprintf(filename,255,"/media/mmc1/_apg/liq.%s.page",fmtnow  );
    }
    //else
    {
        snprintf(filename,255,"%s/liq.%s.%s.page",app.sketchpath,fmtnow,app.username  );
	}
	page_filesave(page,filename);
	
	
/*	
	if(isinternetsketch==0) return;
	
	
	// this is not to be included in packaged versions.  i will perform the upload under socket control
	// rather than this horrible hack




	cliprect_drawtextinside(canvas.cr,canvas.font,0,0,canvas.pixelwidth,canvas.pixelheight,"Please wait, uploading now",1);
	canvas_refreshdisplay();


	// removed the following automatic upload code until another time
	// i will do it as a partial update later on, i dont feel "right" at present due to lack of login security
	// will continue to speak to people until something viable develops.
		
	
	char syscmd[1024+1];
    snprintf(syscmd,1024,"wget --output-file=/dev/null --post-file=`./liqbase_sketchencode.py %s` http://www.liqbase.net/push_sketch.php ",filename  );
	
	int res=system(syscmd);
	app_log("wget for '%s' gave %i",syscmd,res);
	// 0==ok
	if(res==-1)
	{
		// error uploading
		
	}
	
	// ######################################################### ensure we have an upload directory available.
	char buf[FILENAME_MAX+1];
	snprintf(buf,FILENAME_MAX,"%s/_uploaded",app.sketchpath);
	if(!app_pathexists(buf))
	{
		int status;
		status = mkdir(buf, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
		if(status)
		{
			app_log("app error: could not mkdir '%s'",buf);
			return -1;			
		}
	}
	
	
	// ######################################################### build set of filenames
	
	char fnmid[1024+1];
    snprintf(fnmid,1024,"%s/liq.%s.%s.page.post",app.sketchpath,fmtnow,app.username  );
	
	char fndest[1024+1];
    snprintf(fndest,1024,"%s/_uploaded/liq.%s.%s.page.post",app.sketchpath,fmtnow,app.username );
	
	
	// ######################################################### perform the rename now
	// now, move the uploaded file
	int rr=rename(fnmid,fndest);
	
	if(rr!=0)
	{
		app_log("app error: could not rename '%s' to '%s'",fnmid,fndest);
		return -1;
	}
	
	
*/	
	

}














void navmenu_regen()
{
liqtile *t;
	
		if( (t=liqtile_childfindkey(tiletools,"save")) )
		{
			if(strokesdrawn)
				t->style = stylebutton;
			else
				t->style = NULL;
		}
		
		if( (t=liqtile_childfindkey(tiletools,"undo")) )
		{
			if(strokesdrawn)
				t->style = stylebutton;
			else
				t->style = NULL;
		}
		
		if( (t=liqtile_childfindkey(tiletools,"revert")) )
		{
			if(strokesdrawn)
				t->style = stylebutton;
			else
				t->style = NULL;
		}
		
		if( (t=liqtile_childfindkey(tiletools,"clear")) )
		{
			if(strokesdrawn)
				t->style = stylebutton;
			else
				t->style = NULL;
		}
		
		if( (t=liqtile_childfindkey(tiletools,"<")) )
		{
			if(page->owner && page->owner->linkprev && page->owner->linkprev->linkpage)
				t->style = stylebutton;
			else
				t->style = NULL;
		}
	
		if( (t=liqtile_childfindkey(tiletools,">")) )
		{
			if(page->owner && page->owner->linknext && page->owner->linknext->linkpage)
				t->style = stylebutton;
			else
				t->style = NULL;
		}
		
}













static int tool_undo_click(struct liqtile *self)
{
	// remove the top most stroke from the stack.
	// im not sure it will work..
	
	// so far, all new strokes are appended
	app_log("undo starting.................");
	if(page==NULL) return 0;
	if(page->strokecount==0) return 0;
	if(strokesdrawn==0) return 0;
	
	
	
	page_strokeremove(page,page->strokelast);
	strokesdrawn--;
		
	navmenu_regen();
	return 0;
}




static int tool_clear_click(struct liqtile *self)
{
		// reload from its own name
		if(page->filename)
		{
			char *fn=strdup(page->filename);
			page_fileload(page,fn);
			free(fn);
		}
		else
		{
			page_clear(page);
		}
		strokesdrawn=0;
		
		navmenu_regen();
		return 0;
}





static int tool_goto_prev_click(struct liqtile *self)
{
	
	if(page->owner->linkprev && page->owner->linkprev->linkpage)
	{
		// save if required
		save_now();
		
		page=page->owner->linkprev->linkpage;

		strokesdrawn=0;
		
		navmenu_regen();

		
	}
	return 0;
}


static int tool_goto_next_click(struct liqtile *self)
{
	
	if(page->owner->linknext && page->owner->linknext->linkpage)
	{
		// save if required
		save_now();
		
		page=page->owner->linknext->linkpage;

		strokesdrawn=0;
		
		navmenu_regen();
	}
	return 0;
}


static int tool_save_click(struct liqtile *self)
{
	
	if(page)
	{
		// save if required :)
		if(page->filename)
		{
			save_now();
			
		}
		else
		{
			// no filename, so clear
			save_now();
			
			page_clear(page);
			
		}

		strokesdrawn=0;
		
		navmenu_regen();
	}
	return 0;
}
























static int tool_colorbright_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is clicking inside brightness strip
	// adjust the colorpalette brightness to match grey under cursor
	// also, set the cursor to the grey we have detected (or white..)
	int ox=0;
	int oy=0;
	liqtile_getabsoluteoffset(self,&ox,&oy);
	ox+=self->x;
	oy+=self->y;
	
	
	char cy,cu,cv;
	cliprect_drawpgetcolor(canvas.cr,args->mex,args->mey,&cy,&cu,&cv);
	
	char py,pu,pv;
	liqstyle_getbackcoloryuv(stylecolorpalette,&py,&pu,&pv);
	
	
	liqstyle_setbackcoloryuv(stylecolorpalette,cy,pu,pv);

	// now use to set the pen
	liqstyle_setbackcoloryuv(stylepencolor,cy,cu,cv);
	return 0;

}

static int tool_colorpalette_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is clicking inside colorcube
	// adjust the pencolor to match color under cursor
	int ox=0;
	int oy=0;
	liqtile_getabsoluteoffset(self,&ox,&oy);
	ox+=self->x;
	oy+=self->y;
	
	
		//app_log("colorpalette 1 self:%3i,%3i m:%3i,%3i o:%3i,%3i ",self->x,self->y, args->mex,args->mey,  ox,oy);

	
	char cy,cu,cv;
	cliprect_drawpgetcolor(canvas.cr,args->mex,args->mey,&cy,&cu,&cv);

		//app_log("colorpalette 2 self:%3i,%3i m:%3i,%3i o:%3i,%3i ",self->x,self->y, args->mex,args->mey,  ox,oy);


	
	liqstyle_setbackcoloryuv(stylepencolor,cy,cu,cv);
		//app_log("colorpalette 3 self:%3i,%3i m:%3i,%3i o:%3i,%3i ",self->x,self->y, args->mex,args->mey,  ox,oy);
		
	return 0;
}

static int tool_item_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is clicking a tool within the toolstrip
	// change the page_mousehandler according to which tool actually clicked on
	// this could simply be set in the .tag property, or something equally benign :)
	// I know it will be one or other of the following tools
	if(args->mez>0)
	{
		// we should show the tool highlighted or something?
	}
	else
	{
		// back to normal now
		tilepage->handlermouse = (void*)self->tag;
		
		// set the current selection within the group
		liqtile *t = tiletools->linkchild;
		while(t)
		{
			if(t->tag)
			{
				if(t==self)
					t->style = stylebuttonsel;
				else
					t->style = stylebutton;
			}
				
			t=t->linknext;
		}
		
	}
	return 0;
}



























static int page_drawstroke_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing a stroke on page
	// 
	if(args->mez>0)
	{
		if(args->mcnt==1)
		{
			strokesdrawn++;
			navmenu_regen();
			//app_log("mouse new");
			// new
			// we should insert a stroke into the page
			char py,pu,pv;
			liqstyle_getbackcoloryuv(stylepencolor,&py,&pu,&pv);
			strokecurr = stroke_alloc();
			strokecurr->pen_y=py;
			strokecurr->pen_u=pu;
			strokecurr->pen_v=pv;
			stroke_start(strokecurr,args->mex,args->mey,args->mez);
			page_strokeinsert(page,strokecurr);
		}
		else
		{
			// ongoing
			// we should extend the stroke in the page
			// we should render the partial last section of the newest stroke :)
			stroke_extend(strokecurr,args->mex,args->mey,args->mez);
			page_strokeupdate(page,strokecurr);
			stroke_render(strokecurr,0);
		}
	}
	else
	{
			// ending, we could do a full render?
			stroke_extend(strokecurr,args->mex,args->mey,strokecurr->pointlast->z);
			page_strokeupdate(page,strokecurr);
			app_log("############ %s %2i,%2i",stroke_quadchainbuild(strokecurr),page->islandcount,strokecurr->islandnumber);
		
			strokecurr=NULL;
	}
	return 0;
}

static int page_drawline_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing a line on page
	if(args->mez>0)
	{
		if(args->mcnt==1)
		{
			strokesdrawn++;
			navmenu_regen();
			//app_log("mouse new");
			// new
			// we should insert a stroke into the page
			char py,pu,pv;
			liqstyle_getbackcoloryuv(stylepencolor,&py,&pu,&pv);
			strokecurr = stroke_alloc();
			strokecurr->strokekind = 1;		// the only difference ;)
			strokecurr->pen_y=py;
			strokecurr->pen_u=pu;
			strokecurr->pen_v=pv;
			stroke_start(strokecurr,args->mex,args->mey,args->mez);
			page_strokeinsert(page,strokecurr);
		}
		else
		{
			// ongoing
			// we should extend the stroke in the page
			// we should render the partial last section of the newest stroke :)
			stroke_extend(strokecurr,args->mex,args->mey,args->mez);
			page_strokeupdate(page,strokecurr);
			stroke_render(strokecurr,0);
		}
	}
	else
	{
			// ending, we could do a full render?
			stroke_extend(strokecurr,args->mex,args->mey,strokecurr->pointlast->z);
			page_strokeupdate(page,strokecurr);
			strokecurr=NULL;
	}
	return 0;
}

static int page_drawbox_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing a box on page


	if(args->mez>0)
	{
		if(args->mcnt==1)
		{
			
			//app_log("mouse new");
			// new
			// we should insert a stroke into the page
			strokesdrawn++;
			navmenu_regen();
			
			char py,pu,pv;
			liqstyle_getbackcoloryuv(stylepencolor,&py,&pu,&pv);
			strokecurr = stroke_alloc();
			strokecurr->strokekind = 2;		// the only difference ;)
			strokecurr->pen_y=py;
			strokecurr->pen_u=pu;
			strokecurr->pen_v=pv;
			stroke_start(strokecurr,args->mex,args->mey,args->mez);
			page_strokeinsert(page,strokecurr);
		}
		else
		{
			// ongoing
			// we should extend the stroke in the page
			// we should render the partial last section of the newest stroke :)
			stroke_extend(strokecurr,args->mex,args->mey,args->mez);
			page_strokeupdate(page,strokecurr);
			stroke_render(strokecurr,0);
		}
	}
	else
	{
			// ending, we could do a full render?
			stroke_extend(strokecurr,args->mex,args->mey,strokecurr->pointlast->z);
			stroke_ensurepositive(strokecurr);
			page_strokeupdate(page,strokecurr);
			
			strokecurr=NULL;
	}
	return 0;
}

static int page_drawarea_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing an area on page

	if(args->mez>0)
	{
		if(args->mcnt==1)
		{
			//app_log("mouse new");
			// new
			// we should insert a stroke into the page
			strokesdrawn++;
			navmenu_regen();
			
			char py,pu,pv;
			liqstyle_getbackcoloryuv(stylepencolor,&py,&pu,&pv);
			strokecurr = stroke_alloc();
			strokecurr->strokekind = 3;		// the only difference ;)
			strokecurr->pen_y=py;
			strokecurr->pen_u=pu;
			strokecurr->pen_v=pv;
			stroke_start(strokecurr,args->mex,args->mey,args->mez);
			page_strokeinsert(page,strokecurr);
		}
		else
		{
			// ongoing
			// we should extend the stroke in the page
			// we should render the partial last section of the newest stroke :)
			stroke_extend(strokecurr,args->mex,args->mey,args->mez);
			page_strokeupdate(page,strokecurr);
			stroke_render(strokecurr,0);
		}
	}
	else
	{
			// ending, we could do a full render?
			stroke_extend(strokecurr,args->mex,args->mey,strokecurr->pointlast->z);
			stroke_ensurepositive(strokecurr);
			page_strokeupdate(page,strokecurr);
			strokecurr=NULL;
	}
	return 0;
}

static int page_drawstamp_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing a stamp on page
	
	if(args->mez>0)
	{
		if(args->mcnt==1)
		{
			strokesdrawn++;
			navmenu_regen();
			//app_log("mouse new");
			// new
			// we should insert a stroke into the page
			char py,pu,pv;
			liqstyle_getbackcoloryuv(stylepencolor,&py,&pu,&pv);
			strokecurr = stroke_alloc();
			strokecurr->strokekind = 4;		// the only difference ;)
			//strokecurr->mediapage = altpage;
			strokecurr->mediapage = page;
			strokecurr->pen_y=py;
			strokecurr->pen_u=pu;
			strokecurr->pen_v=pv;
			stroke_start(strokecurr,args->mex,args->mey,args->mez);
			page_strokeinsert(page,strokecurr);
		}
		else
		{
			// ongoing
			// we should extend the stroke in the page
			// we should render the partial last section of the newest stroke :)
			stroke_extend(strokecurr,args->mex,args->mey,args->mez);
			page_strokeupdate(page,strokecurr);
			stroke_render(strokecurr,0);
		}
	}
	else
	{
			// ending, we could do a full render?
			stroke_extend(strokecurr,args->mex,args->mey,strokecurr->pointlast->z);
			stroke_ensurepositive(strokecurr);
			page_strokeupdate(page,strokecurr);
			strokecurr=NULL;
	}
	return 0;
}
/*
static int page_drawpaint_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is painting all points closeby
	// there is no selection it is merely the points/strokes on the page
	
	if(args->mez==0)
	{
		//mksketch_run(altpage);
		
		//mkfileselect_run();
	
	
	//	mkproject_run();
	}
	return 0;
}
 */


//#################################################################################
//################################################################################# selection box handling
//#################################################################################



/*

static int page_select_new_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is dragging a box and each stroke within is selected
	// the user starts to draw within the current selection rect we move the contents
	// every single point of every stroke within the selection is relocated physically by the offset :)
	return 0;
}
static int page_select_move_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is dragging within the selection
	// every single point of every stroke within the selection is relocated physically by the offset :)
	return 0;
}

static int page_select_resize_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is grabbed the resize nobble
	// every single point of every stroke within the selection is scaled  :)
	return 0;
}




 */















































//#################################################################################
//################################################################################# drawing of the entities
//#################################################################################






static void stroke_render(STROKE *sa,int flagshowall)
{
	
	int tox = 0;
	int toy = 0;

	int tmx = 1;
	int tmy = 1;


	int fox = 0;
	int foy = 0;
	
	int fmx = 1;
	int fmy = 1;	
	
	
	unsigned char y=sa->pen_y;
	unsigned char u=sa->pen_u;
	unsigned char v=sa->pen_v;

	
	
			POINT *p1;
			POINT *p2;
			
			int p1x;
			int p1y;
			
			int p2x;
			int p2y;
			
			int lsx;
			int lsy;
			int lex;
			int ley;

	if (sa->pointcount<2) return;

			//######################################## normal stroke
			if(sa->strokekind==0)
			{
				// this is the newer version, without any quality reduction :)
				p1 = sa->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = p1->linknext;
				while(p2)
				{
					
					p2x=p2->x;   // rotate now..
					p2y=p2->y;
					
					// the heavy math part is here...
					lsx=tox+((p1x-fox)*tmx/fmx);
					lsy=toy+((p1y-foy)*tmy/fmy);
					lex=tox+((p2x-fox)*tmx/fmx);
					ley=toy+((p2y-foy)*tmy/fmy);
	
	
	
					// high definition color scaling :)
					int g=(450-p1->z);
					g=(g*256) / 250;
					if(g<0)g=0;
					if(g>255)g=255;			
					float f=(float)g / 256;
					float fy=y;
					float fu=u;
					float fv=v;
					unsigned char sy=	    (char)(      f * (fy    )) ;
					unsigned char su=	    (char)(128 + f * (fu-128)) ;
					unsigned char sv=	    (char)(128 + f * (fv-128)) ;
					
					
					// view identified island colors...
		/*			int isle = sa->islandnumber;
					sy=64+192*(isle % 4)/4;
					su = 32 *  (isle      % 8);
					sv = 32 * ((isle / 8) % 8);
					
		*/			
					cliprect_drawlinecolor(canvas.cr,lsx,lsy,lex,ley,    sy,su,sv);
				
					
					
					
					
					//cliprect_drawlinecolor(self,lsx,lsy,lex,ley,    y,u,v);
					
					//canvas_line(lsx,lsy,lex,ley,    y);
	
					p1=p2;
					p2=p2->linknext;
					
					p1x=p2x;
					p1y=p2y;
				/*
				 
					// automatic quality reduction part is here
					// removed from the live editor because we need it high res
					if(p2)
					{	// move us on, at this point, rendering half resolution is ok :)
						//todo: make this work properly, dropoff with scale is too steep
						int cnt=rpt;
						while(p2->linknext && cnt-->0)
							p2=p2->linknext;	
						// i could do this by a factor of anything and reduce resolution as difference increases
					}
				*/
				}
				
				
			}	
	
			//######################################## crows nest line
			else if(sa->strokekind==1)
			{
				p1 = sa->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = sa->pointlast;
				p2x=p2->x;   // rotate now..
				p2y=p2->y;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
	
				cliprect_drawlinecolor(canvas.cr,lsx,lsy,lex,ley,    y,u,v);
			}
			
			//######################################## simple box outline
			else if(sa->strokekind==2)
			{
				p1 = sa->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = sa->pointlast;
				p2x=p2->x;   // rotate now..
				p2y=p2->y;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
	
				cliprect_drawboxlinecolor(canvas.cr,lsx,lsy,lex-lsx,ley-lsy,    y,u,v);
			}
			
			//######################################## filled box
			else if(sa->strokekind==3)
			{
				p1 = sa->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = sa->pointlast;
				p2x=p2->x;   // rotate now..
				p2y=p2->y;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
	
				cliprect_drawboxfillcolor(canvas.cr,lsx,lsy,lex-lsx,ley-lsy,    y,u,v);
			}
			//######################################## subpage (gulp!)
			else if(sa->strokekind==4)
			{
				//p1 = sa->pointfirst;
				//p1x=p1->x;	// rotate now..
				//p1y=p1->y;
				
				//p2 = sa->pointlast;
				//p2x=p2->x;   // rotate now..
				//p2y=p2->y;
				
				p1x=sa->boundingbox.xl;
				p1y=sa->boundingbox.yt;
				p2x=sa->boundingbox.xr;
				p2y=sa->boundingbox.yb;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
				
				
				cliprect_drawpage(canvas.cr,sa->mediapage,lsx,lsy,lex-lsx,ley-lsy,0);
				cliprect_drawboxlinecolor(canvas.cr,lsx,lsy,lex-lsx,ley-lsy,    y,u,v);

			}
	
}









static int page_paint(struct liqtile *self,liqtileeventpaint *args)
{
	if(strokecurr && strokecurr->strokekind==0)
	{
		// normal stroke is already done by the respective party :)
		//stroke_render(strokecurr,0);
	}
	else
	{
		cliprect_drawclear(args->cr,0,128,128);
		
		self->handlerpaint=NULL;
		liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
		self->handlerpaint=page_paint;
		//app_log("draw all");
		//canvas_clear(0);
	
		//int a,b;
		STROKE *sa=page->strokefirst;
		while(sa)
		{
			stroke_render(sa,1);
			sa=sa->linknext;
		}
	}
	return 0;
}






static int page_event(struct liqtile *self,LIQEVENT *ev)
{
	// grab keys here :)
	//app_log("event!!!!! %i",ev->key.keycode);	
			if( (ev->type == LIQEVENT_TYPE_KEY) && (ev->state==LIQEVENT_STATE_PRESS) && (ev->key.keycode==65477) )	//Zoom -
			{
				app_log("event!!!!! keypress zoom- %i",ev->key.keycode);
				liqtile *t=NULL;
				if( (t=liqtile_childfindkey(tiletools,"<")) )
				{
					app_log("event!!!!! got <");
					if( (t->style == stylelabel) && t->handlerclick )
					{
						app_log("event!!!!! firing");
						t->handlerclick(t);
					}
				}				

			}
			else if( (ev->type == LIQEVENT_TYPE_KEY) && (ev->state==LIQEVENT_STATE_PRESS) && (ev->key.keycode==65476) )	//Zoom +
			{
				app_log("event!!!!! keypress zoom+ %i",ev->key.keycode);
				liqtile *t=NULL;
				if( (t=liqtile_childfindkey(tiletools,">")) )
				{
					app_log("event!!!!! got >");
					
					if( (t->style == stylelabel) && t->handlerclick )
					{
						app_log("event!!!!! firing");
						t->handlerclick(t);
					}
				}
				

			}
	return 0;
}







































//###############################################################################
//############################################################################### main code
//###############################################################################



int liqtile_easyrun(liqtile *self);


int liqart2_run_editdocument(PAGE *basepage)
{
	app_log("art2 starting (non recursive, so watch it...)");
	
	tilecurr=NULL;
	
	strokesdrawn=0;
	
	if(mk_style_open()!=0)
	{
		// failed
		app_log("mk_style could not open");
		return -1;
	}
	
	// we do not need to runfast this time :)
	runfast=0;
	

	//page_init();
	
	page=basepage;
	strokecurr=NULL;

	
	// ############################################### create some styles :)


	liqstyle_setbackcoloryuv(stylecolorbright,255,128,128);
	liqstyle_setbackcoloryuv(stylecolorpalette,128,128,128);
	liqstyle_setbackcoloryuv(stylepencolor,255,128,128);

	
	app_log("art2 scanning");
	
	
		tileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
		//tileroot->handlermouse=page_drawstroke_mouse;
		tileroot->handlerpaint=page_paint;
		tileroot->handlerevent=page_event;
		tileroot->style=stylenone;
		
		tilepage=liqtile_createquick("page", canvas.pixelwidth*0, 0,     canvas.pixelwidth*0.8, canvas.pixelheight*1.0  );
		//tilepage->style=stylegrid;
		tilepage->handlermouse=page_drawstroke_mouse;
		//tilepage->handlerpaint=page_paint;
		liqtile_childappend(tileroot,tilepage);
		
		
		
		tiletools=liqtile_createquick("menu",canvas.pixelwidth*0.8,0,   canvas.pixelwidth*0.2,canvas.pixelheight*0.7);
		tiletools->style=stylenone;
		//tilemenu->handlermouse=tilemenu_mouse;
		liqtile_childappend(tileroot,tiletools);
		
		
		
			// create the tools now :)
			liqtile *t;


			t=liqtile_createquick("undo",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)0;//page_select_move_mouse;
			t->handlerclick=tool_undo_click;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
		
			t=liqtile_createquick("curve",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebuttonsel;
			t->tag=(int)page_drawstroke_mouse;
			t->handlermouse=tool_item_mouse;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);

			t=liqtile_createquick("line",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)page_drawline_mouse;
			t->handlermouse=tool_item_mouse;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);

			t=liqtile_createquick("box",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)page_drawbox_mouse;
			t->handlermouse=tool_item_mouse;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
			

			t=liqtile_createquick("area",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)page_drawarea_mouse;
			t->handlermouse=tool_item_mouse;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);



			t=liqtile_createquick("stamp",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)page_drawstamp_mouse;
			t->handlermouse=tool_item_mouse;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
			
			t=liqtile_createquick("spacer",0,0,  canvas.pixelwidth*0.2,canvas.pixelheight*0.025);
			//t->style=stylelabel;
			t->tag=(int)0;
			t->handlermouse=NULL;
			liqtile_childappend(tiletools,t);
	
			t=liqtile_createquick("save",0,0,  canvas.pixelwidth*0.2,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)0;
			//t->handlermouse=NULL;
			t->handlerclick=tool_save_click;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
			
			t=liqtile_createquick("spacer",0,0,  canvas.pixelwidth*0.2,canvas.pixelheight*0.025);
			//t->style=stylelabel;
			t->tag=(int)0;
			t->handlermouse=NULL;
			liqtile_childappend(tiletools,t);
	
	
if(!basepage->filename)
{
	// new
			t=liqtile_createquick("clear",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)0;
			t->handlerclick=tool_clear_click;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
			
}
else
{
	// edit
			t=liqtile_createquick("revert",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
			t->style=stylebutton;
			t->tag=(int)0;
			t->handlerclick=tool_clear_click;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
	
}


if(!basepage->owner)
{
	// we are totally stand alone, we clear
}
else
{
	// we are within an eco system, we revert or advance/previous
	
			t=liqtile_createquick("spacer",0,0,  canvas.pixelwidth*0.2,canvas.pixelheight*0.025);
			//t->style=stylebutton;
			t->tag=(int)0;
			t->handlermouse=NULL;
			liqtile_childappend(tiletools,t);
			
			
			t=liqtile_createquick("<",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
	//if(basepage->owner->linkprev && basepage->owner->linkprev->linkpage)
	//{
			t->style=stylebutton;
	//}
			t->tag=(int)0;
			t->handlerclick=tool_goto_prev_click;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);
	
	
	
	
			t=liqtile_createquick(">",0,0,  canvas.pixelwidth*0.1,canvas.pixelheight*0.1);
	//if(basepage->owner->linknext && basepage->owner->linknext->linkpage)
	//{
			t->style=stylebutton;
	//}
			t->tag=(int)0;
			t->handlerclick=tool_goto_next_click;
			liqtile_childappend(tiletools,t);
			liqtile_pageautoloadbytitle(t,app.userpath);

			
}			

			
			liqtile_neatarrange(tiletools);
		
		
			t=liqtile_createquick("bright", canvas.pixelwidth*0.8,canvas.pixelheight*0.7,  canvas.pixelwidth*0.2,canvas.pixelheight*0.1);
			t->style=stylecolorbright;
			t->handlermouse=tool_colorbright_mouse;
			liqtile_childappend(tileroot,t);

			t=liqtile_createquick("palette", canvas.pixelwidth*0.8,canvas.pixelheight*0.8,  canvas.pixelwidth*0.2,canvas.pixelheight*0.2);
			t->style=stylecolorpalette;
			t->handlermouse=tool_colorpalette_mouse;
			liqtile_childappend(tileroot,t);

		app_log("art2 easyrun %s(%i,%i)",tileroot->key,tileroot->w,tileroot->h);
			
		navmenu_regen();
		
		//liqtile_print2(liqtileroot);
		liqtile_easyrun2(tileroot,&runfast);
		
		app_log("art2 closing tile");
		
		//liqtile_freecustom(tileroot);
		liqtile_close(tileroot);
	

	save_now();
	
	mk_style_close();

	app_log("floatgallery complete");
	return 0;
}





//###############################################################################
//############################################################################### fake main code - this is called to make a new page :)
//###############################################################################







int liqart2_run()
{
PAGE *page;
	page = page_alloc();
	page->pixelwidth=800;//=canvas.pixelwidth;
	page->pixelheight=480;//canvas.pixelheight;

	page->dpix=225;// *canvas.scalew;
	page->dpiy=225;// *canvas.scaleh;

	
	liqart2_run_editdocument(page);
	
	page_free(page);
	return 0;
}





