/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Module for Basic art sketching
 *
 */




#include <stdlib.h>
#include <stdio.h>
#include <string.h>



#include <X11/keysym.h>

#include "liqapp.h"
#include "liqbook.h"
#include "liqcanvas.h"

#include "liqdialog.h"

#include "liqtextbuffer.h"

#include "liqdoc.h"

#include "liqdraw.h"

STROKE 	*strokecurr=NULL;
PAGE 	*page=NULL;
//PAGE 	*pages[1000];
int 	pagecount=0;

TB titlebuffer={NULL,0};

void save_now()
{
	if(page==NULL) return;
	if(page->strokecount==0) return;
	
	char 		fmtnow[255];
	 			app_formatnow(fmtnow,255,"yyyymmdd_hhmmss");

	//char        key[255];

	char 		filename[255];
	
	if(titlebuffer.bufferlen==0)
	{
		snprintf(filename,255,"/home/user/MyDocs/_apg/liq.%s.page",fmtnow  );
    }
    else
    {
        snprintf(filename,255,"/home/user/MyDocs/_apg/liq.%s.page.%s",fmtnow,titlebuffer.buffer  );
	}


	page_filesave(page,filename);
	page_free(page);

	PAGE *pg=page_alloc();
	page_fileload(pg,filename);
	page=pg;

}

unsigned char cubegrey=255;



static void prog_init()
{
	page = page_alloc();
	page->pixelwidth=canvas.pixelwidth;
	page->pixelheight=canvas.pixelheight;

	page->dpix=225*canvas.scalew;
	page->dpiy=225*canvas.scaleh;
}

static void stroke_render(STROKE *sa,int flagshowall)
{
	POINT *p0;
	POINT *p1;


	if (sa->pointcount<2) return;

	if(flagshowall)
	{
		p0 = sa->pointfirst;
	}
	else
	{
		// start at end-1
		p0 = sa->pointlast->linkprev;
	}
	//return;
	//for(p=ps;p<sa->pointcount;p++)
	while(p0)
	{
		//app_log("render p0:%i p0->linknext:%i showall %i",(unsigned int)p0,(unsigned int)p0->linknext,flagshowall);

		p1 = p0->linknext;
		if(!p1) break;

		// now i am using a linked list, should i draw backwards and just stop if i need to?

		// Pressure gradient:
		// 100 == MEDIC!
		// 150 == ouch
		// 200 == ahhh
		// 300 == you there
		// 450 == hello?

		int g=(450-p0->z);
		g=(g*256) / 250;
		if(g<0)g=0;
		if(g>255)g=255;			
		float f=(float)g / 256;

		float fy=sa->pen_y;
		float fu=sa->pen_u;
		float fv=sa->pen_v;

		unsigned char y=	    (char)(      f * (fy    )) ;
		unsigned char u=	    (char)(128 + f * (fu-128)) ;
		unsigned char v=	    (char)(128 + f * (fv-128)) ;
		//app_log("Line (%i,%i) -(%i,%i)",p0->x,p0->y,p1->x,p1->y);
		canvas_linecolor(p0->x,p0->y,p1->x,p1->y,y,u,v);//p0->x % 255,p0->y % 255);
		p0=p1;
	}
}

unsigned char cc_bright=128;
unsigned char pen_y=255;
unsigned char pen_u=128;
unsigned char pen_v=128;

static void prog_renderall()
{
	canvas_clear(0);
	//canvas_drawcolorcube(canvas.pixelwidth-256,0,50);//cubegrey);
	canvas_drawcolorcube(canvas.pixelwidth-256,0,cc_bright);//cubegrey);
	int x;
	int o=canvas.pixelwidth-256;
	for(x=0;x<256;x++)
		canvas_line(o+x,256,o+x,300,x);

	//int a,b;
	STROKE *sa=page->strokefirst;
	while(sa)
	{
		stroke_render(sa,1);
		sa=sa->linknext;
	}
}

void liqart_clear()
{
	page_clear(page);
	strokecurr=NULL;
}

int liqart_run()
{	
int framecount=0;
	cc_bright=128;
	pen_y=255;
	pen_u=128;
	pen_v=128;
	
	tb_clear( &titlebuffer );

int running=1;
unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mx=0,my=0,mp=0;
//int mcnt=0;
int mk=0;
int mkc=0;
int dirty=1;		// ensure we are drawn at least once :)
	prog_init();
	prog_renderall();
	while(running==1)
	{
		while(canvas_eventcount())
		{
waitevent:
			canvas_nextevent(&ev);

			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) )
			{
				mk=ev.key.keycode;				
				mkc++;
				dirty=1;
				     if( (ev.key.keycode==XK_Escape) )
				{
					app_log("Escape Pressed, stopping program");
					running=0;
					break;
				}
				else if( (ev.key.keycode==65293 ) ) // DPAD FIRE
				{
				}
				else if( (ev.key.keycode==65362 ) ) // DPAD UP
				{
				}
				else if( (ev.key.keycode==65364 ) ) // DPAD DOWN
				{
				}
				else if( (ev.key.keycode==65361 ) ) // DPAD LEFT
				{
					if(titlebuffer.bufferlen>0)						
					{
						if(titlebuffer.cursorpos>0)
						{
							titlebuffer.cursorpos--;
							titlebuffer.cursorlen=0;
							dirty=1;
						}
					}
				}
				else if( (ev.key.keycode==65361 ) ) // DPAD RIGHT
				{
					if(titlebuffer.bufferlen>0)						
					{
						if(titlebuffer.cursorpos+titlebuffer.cursorlen<titlebuffer.bufferlen)
						{
							titlebuffer.cursorpos+= 1 + titlebuffer.cursorlen;
							titlebuffer.cursorlen=0;
							dirty=1;
						}
						else
						{
							app_log("fail %i+%i < %i == false",titlebuffer.cursorpos,titlebuffer.cursorlen,titlebuffer.bufferlen);
						}
					}
				}
				//else if( (ev.key.keycode==65473 ) ) // MENU
				//{
				//}
				else if( (ev.key.keycode==65475 ) ) // FULLSCREEN
				{
				}
				else if( (ev.key.keycode==65477 ) ) // Zoom-
				{
				}
				else if( (ev.key.keycode==65476 ) ) // Zoom+
				{
				}
				else if( (ev.key.keycode==65474 ) ) // Home
				{
				}
				else if( (ev.key.keycode==65288 ) ) // HWK BACKSPACE
				{
					if(titlebuffer.bufferlen>0)
					{
						// we have a buffer to delete
						if(titlebuffer.cursorlen==0)
						{
							// just delete 1 char to our left if possible
							if(titlebuffer.cursorpos>0)
							{
								titlebuffer.cursorpos--;
								titlebuffer.cursorlen=1;
								tb_insertn(&titlebuffer,"",0);
							}

						}
						else
						{
							// replace selection with ""
							tb_insertn(&titlebuffer,"",0);
						}
					}
				}
				else if( (ev.key.keycode==65421 ) ) // HWK ENTER
				{
				}
				else if( (ev.key.keycode==65027 ) ) // HWK FN
				{
				}
				else if( (ev.key.keycode==65505 ) ) // HWK Left Shift
				{
				}
				else if( (ev.key.keycode==65312 ) ) // HWK Chr
				{
				}
				else if( (ev.key.keycode==65508 ) ) // HWK CTRL
				{
				}
				else if( (ev.key.keycode==65505 ) ) // HWK Right Shift
				{
				}
				//
				else if( (ev.key.keycode==65473 ) )	// HWK MENU
				{
					if(liqdialog_showyesno("Do you want to clear the screen")==0)
					{
						app_log("Menu Button Pressed, clearing screen");
						liqart_clear();
						tb_clear( &titlebuffer );
						prog_renderall();
					}
					else
					{
					//	app_log("Space Pressed, but cancelled");
						prog_renderall();
					}

					dirty=1;
					break;
				}
				else if( (ev.key.keycode>0) && (ev.key.keycode<256) && (titlebuffer.bufferlen<20))
				{
					char ch[2]={0,0};
					ch[0]=ev.key.keycode;
					tb_insert( &titlebuffer,&ch[0] );
					dirty=1;
					break;
				}	

			}
			else if(ev.type == LIQEVENT_TYPE_MOUSE)
			{
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;

				if( strokecurr == NULL && mx>=(canvas.pixelwidth-256) && my<256)
				{
					// pget colorcube...
					//(int x1, int y1, char *y,char *u,char *v);
					canvas_pgetcolor(mx,my,&pen_y,&pen_u,&pen_v);
					app_log("pen  %i,%i: %i,%i,%i",mx,my,pen_y,pen_u,pen_v);					
					break;
				}
				if( strokecurr == NULL && mx>=(canvas.pixelwidth-256) && my>=256 && my<300)
				{
					// pget brightness...
					//(int x1, int y1, char *y,char *u,char *v);
					char py=0;
					char pu=0;
					char pv=0;					
					canvas_pgetcolor(mx,my,&py,&pu,&pv);
					cc_bright=py;
					app_log("cc_bright  %i,%i: %i",mx,my,cc_bright);
					prog_renderall();
					dirty=1;
					break;
				}				
				//if( strokeused<strokecount )
				{
					POINT m;
					m.x=mx;
					m.y=my;
					m.z=mp;
					{
						if(strokecurr==NULL) 
						{
							strokecurr = stroke_alloc();// &strokes[strokeused++];
							strokecurr->pen_y=pen_y;
							strokecurr->pen_u=pen_u;
							strokecurr->pen_v=pen_v;
							stroke_start(strokecurr,m.x,m.y,m.z);
							cubegrey = (my*256/canvas.pixelheight);
							//prog_renderall();
							page_strokeinsert(page,strokecurr);
							dirty=1;
						}
						else if(mp!=0) 
						{
							stroke_extend(strokecurr,m.x,m.y,m.z);
							page_strokeupdate(page,strokecurr);
							stroke_render(strokecurr,0);
							dirty=1;
						}

						if(mp==0) 
						{
							// give it a stubby end
							stroke_extend(strokecurr,m.x,m.y,strokecurr->pointlast->z);
							page_strokeupdate(page,strokecurr);
							dirty=1;
							strokecurr=NULL;
							cubegrey = (my*256/canvas.pixelheight);
							//prog_renderall();
						}
					}
				}
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		if(running==0) break;
		if(dirty)
		{
			char buff[255];
				snprintf(buff,255,"fc %i    %1.5f,  %1.5f             ",framecount,app_fps(tz0,tz1,1),app_fps(tzs,tz0,framecount));
				canvas_drawtext(0,0,buff);
			int tl=canvas.pixelwidth-256;
			int tt=300;
				canvas_drawrect(tl-1,tt,  canvas.pixelwidth-tl,  canvas.font->glyphmaxh,0);
				
				
			{
				canvas_drawtext(tl,tt,titlebuffer.buffer);
				
				// draw the caret
				// first get its size
				int xx=liqfont_textwidthn(canvas.font, titlebuffer.buffer,                         titlebuffer.cursorpos);				
				int ww=liqfont_textwidthn(canvas.font, &titlebuffer.buffer[titlebuffer.cursorpos], titlebuffer.cursorlen);
					canvas_line(tl+xx-1, tt,   tl+xx+ww-1, tt+canvas.font->glyphmaxh-1, 255);
					canvas_line(tl+xx  , tt,   tl+xx+ww,   tt+canvas.font->glyphmaxh-1, 128);
					canvas_line(tl+xx+1, tt,   tl+xx+ww+1, tt+canvas.font->glyphmaxh-1, 255);
			}

			canvas_refreshdisplay();
			dirty=0;
			tz0=tz1;
			tz1=app_GetTicks();
			framecount++;
			goto waitevent;
		}
		else
		{
			goto waitevent;
		}
		tz0=tz1;
		tz1=app_GetTicks();
		framecount++;
	}
	save_now();
	return 0;
}

