/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for app level helper functions
 *
 */




#ifndef LIQAPP_H
#define LIQAPP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <dirent.h>


//#######################################################

typedef struct 
{
	// technically this is a session
	char *	title;
	int 	argc;
	char *	*argv;
	int 	infologgingenabled;
	
	char 	*version;
	
	
	char    *pwd;				// startin path
	char    *username;			// lcuk or whatever is in ~/.liqbase/liqbase.prefs
	char    *homepath;			// ~
	char    *sketchpath;		// /media/mmc1/_apg
	char    *themepath;			// /usr/share/liqbase
	char    *userpath;			// ~/.liqbase
} LIQAPP;

//#######################################################

extern LIQAPP app;

//#######################################################
unsigned long app_GetTicks();
int app_init(int argc, char* argv[],char *title);
int app_log(char *logentry, ...);
int app_errorandfail(int returnstatus,char *logentry);
int app_warnandcontinue(int returnstatus,char *logentry);
int app_close();


float app_fps(unsigned long ts,unsigned long te,unsigned long framecount);

int app_getopt_find(char *optname);
int app_getopt_exist(char *optname);
int app_getopt_hasarg(char *optname);
char *app_getopt_str(char *optname,char *def);
int app_getopt_int(char *optname,int def);

int app_sleep(unsigned long millisec);

void app_turbo_start();
void app_turbo_reset();

int cpufreq_governor_read(char *result,int resultmaxlength);
int cpufreq_governor_write(char *newgovernor);
int cpufreq_governor_changeto(char *newgovernor);


void app_ensurecleanusername(char *usernamewhichismodifiable);

int app_formatnow(char *buffer,int buffersize,char *format);

char *instr(char *string,char *match);


int app_pathexists(char *pathname);
int app_fileexists(char *filename);
char *app_filename_walkoverpath(char *filename);
int 	   app_file_copy (char * from, char * to, int allowoverwrite);

void *app_malloc(size_t size);
void *app_calloc(size_t nelements, size_t bytes);
void app_free(void *pointer);


FILE *     app_fopen(const char *filename, const char *mode);

DIR *      app_opendir(const char *dirname);

int 	   app_system(const char *command);


#ifdef __cplusplus
}
#endif

#endif





