/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * App level helper functions
 *
 */





extern unsigned long   __APP_BUILD_TIME[];
extern unsigned long   __APP_BUILD_DATE[];


extern unsigned long   __APP_VER_MAJOR[];
extern unsigned long   __APP_VER_MINOR[];
extern unsigned long   __APP_VER_REVISION[];
extern unsigned long   __APP_VER_BUILD[];




#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <dirent.h>

#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/types.h>            
#include <fcntl.h>                                                                             
#include <unistd.h>
#include <errno.h>



#include <time.h>			// req for sleep
#include <sys/time.h>		// req for getticks
#include "liqapp.h"


#include "liqbase_prefs.h"

#include "liqbase_hildon.h"


LIQAPP app={0};



// using komodo edit configured to look like vb
// using winscp towards the device and putty
// ssh in windows, openssh from here http://sshwindows.sourceforge.net/download/
// can komodo use ssh based commands for "make"?
// i hope it can because then i get error highlighting and direct no messing builds

char *app_pwd=NULL;
int   app_is_basefs=0;

void app_initpwd()
{
	// get initial PWD
	char buf[FILENAME_MAX + 1];
	if (getcwd(buf, sizeof(buf)) == NULL)
	{
		app_log("pwd: failed");
	}
	// now test to see if we have a liqbase_base_fs available :)
	char buf2[FILENAME_MAX + 1];
	snprintf(buf2, FILENAME_MAX,"%s/liqbase_base_fs", buf);
	struct stat     statbuf;
	if(stat(buf2, &statbuf) == -1)
	{
		// no base_fs to work in
		app_pwd = strdup(buf);
		app_is_basefs = 0;
	}
	else
	{
		// we have a base_fs available, ensure all MEDIA calls are prepended with this
		app_pwd = strdup(buf);
		app_is_basefs = 1;
	}
}

/*

FILE *     app_fopen(const char *filename, const char *mode)
{
	if(app_is_basefs)
	{
		char buf[FILENAME_MAX+1];
		snprintf(buf,FILENAME_MAX,"%s/liqbase_base_fs%s",app_pwd,filename);
		return fopen(buf,mode);
	}
	else
	{
		return fopen(filename,mode);
	}
	
}

DIR *      app_opendir(const char *dirname)
{
	if(app_is_basefs)
	{
		char buf[FILENAME_MAX+1];
		snprintf(buf,FILENAME_MAX,"%s/liqbase_base_fs%s",app_pwd,dirname);
		return opendir(buf);
	}
	else
	{
		return opendir(dirname);
	}
}

int 	   app_system(const char *command)
{
	//
	if(app_is_basefs)
	{
		char buf[FILENAME_MAX+1];
		snprintf(buf,FILENAME_MAX,"%s/liqbase_base_fs%s",app_pwd,command);
		return system(buf);
	}
	else
	{
		return system(command);
	}	
}

 */

//#######################################################################
//#######################################################################
//#######################################################################

void *app_malloc(size_t size)
{
	// app_malloc() simply attempts to do some logging if malloc fails
	void *res = malloc(size);
	if(!res)
	{
		app_log("liqbase malloc(%i) failed");
		return NULL;
	}
	return res;
}
void *app_calloc(size_t nelements, size_t bytes)
{
	// app_calloc() simply attempts to do some logging if malloc fails
	void *res = calloc(nelements,bytes);
	if(!res)
	{
		app_log("liqbase calloc(%i) failed",nelements);
		return NULL;
	}
	return res;
	
}
void app_free(void *pointer)
{
	free(pointer);
}

//#######################################################################
//#######################################################################
//#######################################################################
static int __nsleep(const struct timespec *req, struct timespec *rem)
{
    //struct timespec temp_rem;
    if(nanosleep(req,rem)==-1)
        //__nsleep(rem,&temp_rem);
	{ }
	else
        return 1;
}

int app_sleep(unsigned long millisec)
{
    struct timespec req={0},rem={0};
    time_t sec=(int)(millisec/1000);
    millisec=millisec-(sec*1000);
    req.tv_sec=sec;
    req.tv_nsec=millisec*1000000L;
    __nsleep(&req,&rem);
    return 1;
}
//#######################################################################
//####################################################################### GetTicks
//#######################################################################

unsigned long app_GetTicks()
{
	struct timeval now;
	unsigned long ticks;

	gettimeofday(&now, NULL);
	ticks=(now.tv_sec)*1000+(now.tv_usec)/1000;
	return(ticks);
}

float app_fps(unsigned long ts,unsigned long te,unsigned long framecount)
{
	if(te==ts || framecount==0)
		return 0;
	
	return (float)framecount / (   (float)(te-ts)   *    0.001   );
}
//#######################################################################
//####################################################################### Opt handling
//#######################################################################

int app_getopt_find(char *optname)
{
	// return -1 if the option is not listed
	// otherwise, return the position
	// pass in a null pointer to indicate first unnamed option
	if(optname==NULL)
	{
		return 0;
	}
	else
	{
		int opt;
		for(opt=1;opt<app.argc;opt++)
		{	
			char *label=app.argv[opt];
			if( label[0] == '-'   &&   (strcmp( &label[1] , optname )==0) )
			{
				return opt;
			}
		}
		return -1;
	}	
}

int app_getopt_exist(char *optname)
{
	// check if an option exists
	int opt = app_getopt_find(optname);
	if(opt==-1)	// not found
		return 0;
	return 1;
}
int app_getopt_hasarg(char *optname)
{
	// check if an option has arguments
	int opt = app_getopt_find(optname);
	if(opt==-1)	// not found
		return 0;
	if(app.argc<opt+1) // no value to go along with it
		return 0;
	if( app.argv[opt][0] == '-' )	// no parameter specified
		return 0;
	return 1;
}
char *app_getopt_str(char *optname,char *def)
{
	// get a named option and return as a string
	int opt = app_getopt_find(optname);
	if(opt==-1)	// not found
		return def;
	if(app.argc<=opt+1) // no value to go along with it
		return def;
char *res=app.argv[opt+1];
	if( res[0] == '-' )	// no parameter specified (we moved onto another -option without specifying anything)
		return def;
	return res;
}




int app_getopt_int(char *optname,int def)
{
	// get a named option and return as an integer value
char *param = app_getopt_str(optname,NULL);
	if(param==NULL)
		return def;

char *paramend=NULL;
int res = strtol(param, &paramend, 0);
	if(paramend==NULL)
		return def;
	return res;
}













int app_pathexists(char *pathname)
{
	struct stat     statbuf;
	if(stat(pathname, &statbuf) == -1)
	{
		return 0;
	}
	return 1;
}


int app_fileexists(char *filename)
{
	struct stat     statbuf;
	if(stat(filename, &statbuf) == -1)
	{
		return 0;
	}
	return 1;
}



char *app_filename_walkoverpath(char *filename)
{
	if(!filename || *filename==0)
	{
		return filename;
	}
	char *fnstart = filename;
	char *fnend  = filename;
	// walk quickly to the end
	while(*fnend)
	{
		//todo:make path handling safe
		if(*fnend=='/') fnstart=fnend+1;
		fnend++;
	}
	return fnstart;
}


//http://www.koders.com/cpp/fid0B921B251D9F6C17A083FBD5C9565285C637C785.aspx?s=md5
int app_file_copy (char * from, char * to, int allowoverwrite)
{
    size_t nmemb;
    //int nmemb;
    FILE *ifp, *ofp;
    char buf[BUFSIZ];

    if (!allowoverwrite) {
        if (access(to, F_OK) == 0) {
            //OUTLOG((FUNC, TRWRN, "file %s already exists\n", to));
            return(-1);
        }
        else if (errno != ENOENT) {
            //OUTLOG((FUNC, TRERR, "access(%s, F_OK) failed\n", to));
            return(-2);
        }
    }

    if ((ifp=fopen(from, "r")) == NULL) {
        //OUTLOG((FUNC, TRERR, "%s doesn't exist\n", from));
        return(-3);
    }
    
    if ((ofp=fopen(to, "w+")) == NULL) {
        //OUTLOG((FUNC, TRERR, "can't create %s\n", to));
        fclose(ifp);
        return(-4);
    }

    while ((nmemb=fread(buf, 1, sizeof(buf), ifp)) > 0) {
        if (fwrite(buf, 1, nmemb, ofp) != nmemb) {
            //OUTLOG((FUNC, TRERR, "fwrite failed\n"));
            fclose(ifp);
            fclose(ofp);
            return(-5);
        }
    }

    fclose(ifp);
    fclose(ofp);

    return (0);
}




//#######################################################################
//####################################################################### app init
//#######################################################################




int app_init(int argc, char* argv[],char *title)
{
	
	
//http://osdir.com/ml/gcc.cross-compiling/2004-04/msg00059.html
	
char ver[255];

	snprintf(ver,255,"%lu.%lu.%lu build %lu date %08lx %06lx",(unsigned long)__APP_VER_MAJOR,(unsigned long)__APP_VER_MINOR,(unsigned long)__APP_VER_REVISION,(unsigned long)__APP_VER_BUILD,(unsigned long)__APP_BUILD_DATE,(unsigned long)__APP_BUILD_TIME);
 	
	app.infologgingenabled = 1;
	app.argc = argc;
	app.argv = argv;
	app.title = strdup(title);
	app.infologgingenabled = 1;
	
	
	app.version = strdup(ver);
	

	app_initpwd();
	
	
	

	char *envhome = getenv("HOME");
	if(!envhome)
	{
		// wrong, but will suffice
		envhome="/home/user";
	}
	
	
	
	
	if(app_is_basefs)
	{
		// my dev folder :)
		// this is how my dev folder is configured
		// it allows me to prepare basic data ready for inclusion in the package
		//  /media/mmc1/liqbase_www_jpeg/ or similer, includes a folder called liqbase_base_fs
		// /media/mmc1/_apg contains my sketches
		
		
		char buf[FILENAME_MAX+1];
		
		app_log("~~~ Using dev folder config");
		
		snprintf(buf,FILENAME_MAX,"/media/mmc1/svn/liqbase/_liqbase_home_user");//,app_pwd);
		app.homepath =  strdup(buf);
		app.sketchpath =strdup("/media/mmc1/_apg");
		snprintf(buf,FILENAME_MAX,"%s/liqbase_base_fs/usr/share/liqbase",app_pwd);
		app.themepath = strdup(buf);
		app.pwd =       strdup(app_pwd);

		snprintf(buf,FILENAME_MAX,"%s/.liqbase",app.homepath);
		app.userpath=strdup(buf);		

		app.username =  NULL;//strdup("lcuk");						// read from the liqbase.prefs file
	}
	else
	{
		char buf[FILENAME_MAX+1];

		app_log("~~~ Using std folder config");
		app.homepath = strdup(envhome);
		app.sketchpath = NULL;//strdup("/media/mmc1/_apg");
		app.themepath = strdup("/usr/share/liqbase");
		app.pwd = strdup(app_pwd);

		snprintf(buf,FILENAME_MAX,"%s/.liqbase",app.homepath);
		app.userpath=strdup(buf);		

		app.username = NULL;//strdup("default");						// read from the liqbase.prefs file
	}
	
	
	{
		//
		char buf2[FILENAME_MAX+1];
		snprintf(buf2,FILENAME_MAX,"%s/liqbase.run.log",app.userpath);
		if(app_fileexists(buf2))
		{
			// try to remove it
			remove(buf2);
			// could we? do we care? not for now
		}
		
	}
	
	
	app_log("");
	app_log("########################################################");
	app_log("");
	
	
	app_log("Welcome to %s ver %s",app.title,ver);
	
	
	
	
	//app.username=NULL;

	// ok, now we load user preferences
/*
	{
		
		FILE *fn;
		
		char buf[FILENAME_MAX+1];
		snprintf(buf,FILENAME_MAX,"%s/liqbase.prefs",app.userpath);
		
		fn=fopen(buf,"r");
		if(fn)
		{
			char lineraw[512];
			int linemax=512;
			char *line=NULL;
			while(!feof(fn))
			{
				char * rc;
				rc=fgets(lineraw,linemax, (FILE*) fn);
				if(rc==NULL)
				{
					printf("error reading from preferences\n");
					return -2;
				}
				line=lineraw;
				if(*line)
				{
					while(*line==' ' || *line=='\t')line++;
					
					char *data=instr(line,"=");
					if(data && data>line)
					{
						*data=' ';
						while(line>lineraw && (*data==' ' || *data=='\t'))
						{
							*data-- = 0;
						}
						data++;
						while(*data==' ' || *data=='\t')data++;
						// ok, got a key and a value pair :)
						
						app_log("[%s]=[%s]",line,data);
						
						//if(strcmp(newgovernor,buff_orig) == 0)						
						
					}
				}
			}
			
			fclose(fn);
		}
		
	}
 */	
	
	
	// todo: resolve this fairly simple edge case chicken and egg problem on startup

	
	char buf[FILENAME_MAX+1];
	snprintf(buf,FILENAME_MAX,"%s/.liqbase",app.homepath);
	if(!app_pathexists(buf))
	{
		int status;
		status = mkdir(buf, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
		if(status)
		{
			app_log("app error: could not mkdir '%s'",buf);
			return -1;			
		}
	}
	if(!app.sketchpath)
	{
		// we have not yet configured a sketchpath
		// lets set a default
		// in a few days prefs file loaded will be in place
		// but its not yet..
		snprintf(buf,FILENAME_MAX,"%s/.liqbase/sketches",app.homepath);
		app.sketchpath = strdup(buf);
		
		// make sure it exists
		if(!app_pathexists(buf))
		{
			int status;
			status = mkdir(buf, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
			if(status)
			{
				app_log("app error: could not mkdir '%s'",buf);
				return -1;			
			}
		}		
	}
	
	
	
	
	
	liqbase_prefs_load();
	
	
	char *un = liqbase_pref_getvalue("username");
	if(un)
	{
		//app_log("got username from preferences");
		// we have the preference :)
		{
			if(app.username){free(app.username); app.username=NULL;}
			app.username=strdup(un);
			
			app_ensurecleanusername(app.username);
			
		}		
	}
	
	
		
	app_log("initializing hildon");
	hildon_app_init();
	
	
	app_log("#############");
	app_log("app.user    =%s",app.username);
	app_log("app.start   =%s",app.pwd);
	app_log("app.home    =%s",app.homepath);
	app_log("app.theme   =%s",app.themepath);
	app_log("app.sketches=%s",app.sketchpath);
	app_log("#############");
	
	
	//app_log("%s",ver);
	app_log("You passed %i arguments",argc);
	int i;
	for(i=0;i<argc;i++)
		app_log("Argument %i = %s",i,argv[i]);
/*	
	app_log("Test Options");
	app_log("Test Option     :   '%s'", app_getopt_str(NULL,      "asd")         );
	app_log("Test Option Font:   '%s'", app_getopt_str("font",    "arial.ttf")   );
	app_log("Test Option Size:   %i", app_getopt_int(  "size",    24)            );
	app_log("Test Option Invert: %i", app_getopt_exist("invert")                 );
*/	

	return 0;
	
}




//############################################################# deeplog runs whenever called

int app_vdeeplog(char *logentry, va_list arg)
{
    time_t     now;
    struct tm  *ts;
    char       buf[80];
    time(&now);
    ts = localtime(&now);
    strftime(buf, sizeof(buf), "%H:%M:%S", ts);
	
	
	//printf("%s: %s: ",buf,app.title);
	printf("%s ",buf);

	vprintf(logentry, arg);
	
	puts("");	// dang! this feels bad
	fflush(stdout);
	
	// VERY temporary logging
	char buf2[FILENAME_MAX+1];
	snprintf(buf2,FILENAME_MAX,"%s/liqbase.run.log",app.userpath);
	FILE *fp=fopen(buf2,"a");
	if(fp)
	{
		fprintf(  fp, "%s "   , buf);		// append time
		vfprintf( fp, logentry, arg );		// now the log item
		fputs("\n",fp);
		fclose(fp);
	}
	
	
	return 0;
}

int app_deeplog(char *logentry, ...)
{
	va_list arg;
	va_start(arg, logentry);
	app_vdeeplog(logentry, arg);
	va_end(arg);
	return 0;
}


//############################################################# local log runs only if info messages enabled

int app_log(char *logentry, ...)
{
	//return 0;
	if(app.infologgingenabled==0) return 1;
	va_list arg;
	va_start(arg, logentry);
	app_vdeeplog(logentry, arg);
	va_end(arg);
	return 0;
}


//############################################################# error log runs always

int app_errorandfail(int returnstatus,char *logentry)
{
	char buff[255];
	snprintf(buff,255,"FAILED: %i : %s",returnstatus,logentry);
	app_deeplog(buff);
	exit(returnstatus);
	return returnstatus;
}

int app_warnandcontinue(int returnstatus,char *logentry)
{
	char buff[255];
	snprintf(buff,255,"WARN: %i : %s",returnstatus,logentry);
	app_deeplog(buff);
	return returnstatus;
}
//warnandcontinue


int app_close()
{
	//liqhal_close();
	
	
	hildon_app_close();
	
	if(app_pwd) {free(app_pwd); app_pwd=NULL; }


	if(app.pwd) {free(app.pwd); app.pwd=NULL; }
	if(app.homepath) {free(app.homepath); app.homepath=NULL; }
	if(app.username) {free(app.username); app.username=NULL; }
	if(app.sketchpath) {free(app.sketchpath); app.sketchpath=NULL; }
	if(app.themepath) {free(app.themepath); app.themepath=NULL; }
	if(app.userpath) {free(app.userpath); app.userpath=NULL; }
	if(app.version) {free(app.version); app.version=NULL; }

	app.argc=0;
	app.argv=NULL;
	free(app.title);
	app.title=NULL;
	return 0;

}


char turbo_orig[255]="\0";	// original governor
int turbo_inuse=0;
void app_turbo_start()
{
	turbo_inuse=0;
	int ri;
	app_log("turbo: attempting to upgrade us.");
	ri=cpufreq_governor_read(turbo_orig, 255);
	if(ri!=0){app_errorandfail(-1,"turbo: cannot open governor for reading"); return;}
	app_log("turbo: current = '%s'",turbo_orig);
	if(strcmp("performance",turbo_orig))
	{
		app_log("turbo: need to change (might need permission *todo: add to sudoers?)");
		ri=cpufreq_governor_write("performance");
		if(ri<0){app_errorandfail(-1,"turbo: cannot open governor for writing"); return;}
		turbo_inuse=1;
	}
	else
	{
		app_log("turbo: No action required yet, we are already 'performance'");
		
	}
}

void app_turbo_reset()
{
	int ri;
	if(turbo_inuse)
	{
		app_log("turbo: stepping back down from 'performance' to '%s'",turbo_orig);
		ri=cpufreq_governor_write(turbo_orig);
		if(ri!=0){app_log("ERROR: turbo: cannot restore governor information, we are stuck at 'performance' until full reboot"); return;}
		app_log("turbo: done");
		turbo_inuse=0;
	}
	
}

void app_ensurecleanusername(char *usernamewhichismodifiable)
{
	char *nu=usernamewhichismodifiable;
	while(*nu)
	{
		if(*nu=='\\' || *nu=='/' || *nu=='\'' || *nu=='~' || *nu==' ' || *nu=='\t' || *nu=='\'' || *nu=='"' || *nu==':' || *nu=='|' ||*nu=='#' || *nu=='.' )
			*nu++ = '_';
		else
			nu++;
	}
						
	
}

//#########################################################
//lcuk: cpufreq functions for reading/writing to the governor
//#########################################################

static const char *cpufreq_governor_filename = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor";
int cpufreq_governor_read(char *result,int resultmaxlength)
{
	FILE *fd;
	char *rc;
	fd = fopen(cpufreq_governor_filename, "r");
	if(fd==NULL){ printf("cpufreq, cannot open governor for reading\n"); return -1;}
	rc=fgets(result, resultmaxlength, (FILE*) fd);
	fclose(fd);
	if(rc==NULL){ printf("cpufreq, cannot read governor information\n"); return -2;}
	//lcuk: cleaning off any trailing \n
	char *b=result;	while(*b){  if(*b=='\n'){ *b=0;break; } b++; };
	return 0;
}







int cpufreq_governor_write(char *newgovernor)
{
	//lcuk: instead of directly writing this, I now use an alternative method
	char newcmd[FILENAME_MAX];
	
	
	//if(app_is_basefs)
	//{
	//	snprintf(newcmd,FILENAME_MAX,"sudo %s/usr/bin/liqbase-cpu-%s",app_pwd,newgovernor);
	//}
	//else
	{
		snprintf(newcmd,FILENAME_MAX,"sudo /usr/bin/liqbase-cpu-%s",newgovernor);
	}	
	
	
	if(-1==system(newcmd))
	{
		// the cpu change failed
		{ printf("cpufreq, write: cannot run cmd: '%s'\n",newcmd); return -1; }
	}
	
	//###################################################
    char buff_orig[80]="\0";	// re-read governor
	int ri;
	ri=cpufreq_governor_read(buff_orig,80);
	if(ri!=0){ printf("cpufreq, write: cannot read from governor\n"); return -1; }
	if(strcmp(newgovernor,buff_orig) == 0)
	{
        //lcuk: the setting was applied
		return 0;
	}
	// the setting is different
	{ printf("cpufreq, cannot write to governor '%s', %s, %s\n",newcmd,newgovernor,buff_orig); return -2; }
/*	
	FILE *fd;
	int   ri;
	fd = fopen(cpufreq_governor_filename, "w");
	if(fd==NULL){ printf("cpufreq, cannot open governor for writing\n"); return -1; }
	ri=fputs(newgovernor, (FILE*) fd);
	fclose(fd);
	if(ri<0){ printf("cpufreq, cannot write to governor\n"); return -2; }
	return 0;
 */
}
int cpufreq_governor_changeto(char *newgovernor)
{
    char buff_orig[80]="\0";	// original governor
	int ri;
	ri=cpufreq_governor_read(buff_orig,80);
	if(ri!=0){ printf("cpufreq, cannot read from governor\n"); return -1; }
	if(strcmp(newgovernor,buff_orig) == 0)
	{
        //lcuk: nothing to do..
	    return 0;
	}
    ri=cpufreq_governor_write(newgovernor);
    if(ri!=0){ printf("cpufreq, cannot change the governor\n"); return -2; }
    return 0;
}



//#########################################################
//lcuk: formatted date function
//#########################################################
//todo: add multiple date formats - it currently gives one fixed result it needs to account for params
int app_formatnow(char *buffer,int buffersize,char *format)
{

	struct tm 	*local;
	time_t 		t;
	  			t = time(NULL);
	  			local = localtime(&t);
	
	
	snprintf(buffer,buffersize,"%04i%02i%02i_%02i%02i%02i", 
			 1900+local->tm_year,
			 local->tm_mon+1,			// damn 0 based month..
			 local->tm_mday,
			 
			 local->tm_hour,
			 local->tm_min,
			 local->tm_sec
			 
			 
			 );
	return 0;
}




//#########################################################
//lcuk: instr, standard string handling, should find real home for this
//#########################################################
char *instr(char *string,char *match)
{
	if(!string) return NULL;
	if(!match) return string;
	// return pointer to the match or NULL
	while(*string)
	{
		char *indat = string;
		char *inpat = match;
		while(*indat && *inpat && *indat==*inpat)
		{
			indat++;
			inpat++;
		}
		if(*inpat==0)
		{
			// we found a match at this location
			return string;
		}
		// no match, advance string and loop
		string++;
	}
	return NULL;
}

