/**
 * Copyright (C) 2005 by Koos Vriezen <koos ! vriezen ? xs4all ! nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 **/

//#include <config.h>
#include <string.h>
#include "kmplayer_asx.h"

using namespace KMPlayer;

static String getAsxAttribute (Element * e, const String & attr) {
    for (Attribute *a = e->attributes ()->first (); a; a = a->nextSibling ())
        if (attr == a->name ().toString ().lower ())
            return a->value ();
    return String ();
}

KMPLAYER_NO_EXPORT Node *ASX::Asx::childFromTag (const String & tag) {
    const char * name = (const char *) tag;
    if (!strcasecmp (name, "entry"))
        return new ASX::Entry (m_doc);
    else if (!strcasecmp (name, "entryref"))
        return new ASX::EntryRef (m_doc);
    else if (!strcasecmp (name, "title"))
        return new DarkNode (m_doc, name, id_node_title);
    else if (!strcasecmp (name, "base"))
        return new DarkNode (m_doc, name, id_node_base);
    else if (!strcasecmp (name, "param"))
        return new DarkNode (m_doc, name, id_node_param);
    return NULL;
}

KDE_NO_EXPORT Node::PlayType ASX::Asx::playType () {
    if (cached_ismrl_version != document ()->m_tree_version)
        for (Node *e = firstChild (); e; e = e->nextSibling ()) {
            if (e->id == id_node_title)
                title = e->innerText ().stripWhiteSpace ();
            else if (e->id == id_node_base)
                src = getAsxAttribute (static_cast <Element *> (e), "href");
        }
    return Mrl::playType ();
}

//-----------------------------------------------------------------------------

KMPLAYER_NO_EXPORT Node *ASX::Entry::childFromTag (const String & tag) {
    const char * name = (const char *) tag;
    if (!strcasecmp (name, "ref"))
        return new ASX::Ref (m_doc);
    else if (!strcasecmp (name, "title"))
        return new DarkNode (m_doc, name, id_node_title);
    else if (!strcasecmp (name, "base"))
        return new DarkNode (m_doc, name, id_node_base);
    else if (!strcasecmp (name, "param"))
        return new DarkNode (m_doc, name, id_node_param);
    else if (!strcasecmp (name, "starttime"))
        return new DarkNode (m_doc, name, id_node_starttime);
    else if (!strcasecmp (name, "duration"))
        return new DarkNode (m_doc, name, id_node_duration);
    return NULL;
}

KDE_NO_EXPORT Node::PlayType ASX::Entry::playType () {
    if (cached_ismrl_version != document ()->m_tree_version) {
        ref_child_count = 0;
        Node *ref = NULL;
        for (Node *e = firstChild (); e; e = e->nextSibling ()) {
            switch (e->id) {
            case id_node_title:
                title = e->innerText ().stripWhiteSpace ();
                break;
            case id_node_base:
                src = getAsxAttribute (static_cast <Element *> (e), "href");
                break;
            case id_node_ref:
                ref = e;
                ref_child_count++;
            }
        }
        if (ref_child_count == 1 && !title.isEmpty ())
            static_cast <ASX::Ref *> (ref)->title = title;
        cached_ismrl_version = document()->m_tree_version;
    }
    return play_type_none;
}

KMPLAYER_NO_EXPORT void ASX::Entry::activate () {
    resolved = true;
    for (Node *e = firstChild (); e; e = e->nextSibling ())
        if (e->id == id_node_param) {
            Element *elm = static_cast <Element *> (e);
            if (getAsxAttribute(elm,"name").lower() == String("clipsummary")) {
                String inf = URL::decode_string (
                                getAsxAttribute (elm, "value"));
                document ()->message (MsgInfoString, &inf);
            }
        } else if (e->id == id_node_duration) {
            String s = static_cast <Element *> (e)->getAttribute (
                    StringPool::attr_value);
            int multiply[] = { 1, 60, 60 * 60, 24 * 60 * 60, 0 };
            int mpos = 0;
            double d = 0;
            while (!s.isEmpty () && multiply[mpos]) {
                int p = s.lastIndexOf (Char (':'));
                String t = p >= 0 ? s.mid (p + 1) : s;
                d += multiply[mpos++] * t.toDouble();
                s = p >= 0 ? s.left (p) : String ();
            }
            if (d > 0.00001)
                duration_timer = document()->post (
                        this, new TimerPosting (int (d * 1000)));
        }
    Mrl::activate ();
}

KDE_NO_EXPORT void *ASX::Entry::message (MessageType msg, void *content) {
    if (msg == MsgEventTimer) {
        duration_timer = NULL;
        deactivate ();
        return NULL;
    }
    return Mrl::message (msg, content);
}

KMPLAYER_NO_EXPORT void ASX::Entry::deactivate () {
    document ()->message (MsgInfoString, NULL);
    if (duration_timer) {
        document()->cancelPosting (duration_timer);
        duration_timer = NULL;
    }
    Mrl::deactivate ();
}

KMPLAYER_NO_EXPORT bool ASX::Entry::expose () const {
    return ref_child_count > 1 && !title.isEmpty ();
}

//-----------------------------------------------------------------------------

KMPLAYER_NO_EXPORT void ASX::Ref::opened () {
    src = getAsxAttribute (this, "href");
    Mrl::opened ();
}

KMPLAYER_NO_EXPORT bool ASX::Ref::expose () const {
    return !src.isEmpty ();
}

//-----------------------------------------------------------------------------

KMPLAYER_NO_EXPORT void ASX::EntryRef::opened () {
    src = getAsxAttribute (this, "href");
    Mrl::opened ();
}

