/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _FUELPAD_H_
#define _FUELPAD_H_

#include <sys/time.h>

#include <sqlite3.h>

#define ACCBUFSIZE 100

//#define DEBUG
#ifdef DEBUG
#if (__GNUC__ > 2) && ((__GNUC__ > 3) || (__GNUC_MINOR__ > 2))
#define PDEBUG(fmt...) do {						\
		if (debug_level) {					\
			struct timeval tv;				\
			gettimeofday(&tv, 0);				\
			printf("DEBUG[%d]:%ld.%ld:%s:%s():%d: ",	\
			       getpid(),				\
			       tv.tv_sec, tv.tv_usec,			\
			       __FILE__, __FUNCTION__, __LINE__);	\
			printf(fmt);					\
			fflush(stdout);					\
		}							\
	}while(0)
#else
#define PDEBUG(fmt...) do {						\
		if (debug_level) {					\
			struct timeval tv;				\
			gettimeofday(&tv, 0);				\
			printf("DEBUG[%d]:%ld.%ld:%s:%s():%d: ",	\
			       getpid(),				\
			       tv.tv_sec, tv.tv_usec,			\
			       __FILE__, __FUNCTION__, __LINE__);	\
			printf(##fmt);					\
			fflush(stdout);					\
		}							\
	}while(0)
#endif
#else
#define PDEBUG(fmt...)
#endif

extern int debug_level;
extern volatile int ui_started;
extern unsigned int currentdriver;
extern unsigned int currentcar;
extern sqlite3_stmt *ppStmtDriver;
extern sqlite3_stmt *ppStmtCar;
extern sqlite3_stmt *ppStmtOneDriver;
extern sqlite3_stmt *ppStmtCurCar;
extern sqlite3_stmt *ppStmtOneCar;
extern sqlite3_stmt *ppStmtAddDriver;
extern sqlite3_stmt *ppStmtUpdateDriver;
extern sqlite3_stmt *ppStmtAddCar;
extern sqlite3_stmt *ppStmtUpdateCar;
extern sqlite3_stmt *ppStmtOneRecord;
extern sqlite3_stmt *ppStmtRecords;
extern sqlite3_stmt *ppStmtExport;
extern sqlite3_stmt *ppStmtExportCar;
extern sqlite3_stmt *ppStmtAddRecord;
extern sqlite3_stmt *ppStmtDeleteRecord;
extern sqlite3_stmt *ppStmtUpdateRecord;
extern sqlite3_stmt *ppStmtGetYears;
extern sqlite3_stmt *ppStmtGetReport;
extern sqlite3_stmt *ppStmtAddAlarmtype;
extern sqlite3_stmt *ppStmtGetAlarmtype;
extern sqlite3_stmt *ppStmtGetOneAlarmtype;
extern sqlite3_stmt *ppStmtUpdateAlarmtype;
extern sqlite3_stmt *ppStmtAddEvent;
extern sqlite3_stmt *ppStmtGetEvents;
extern sqlite3_stmt *ppStmtGetOneEvent;
extern sqlite3_stmt *ppStmtDeleteEvent;
extern sqlite3_stmt *ppStmtDeleteEventwithRecordid;
extern sqlite3_stmt *ppStmtUpdateEvent;

double atof_l(const char *nptr, const char *locale);
void db_setfilename(char *fn);
char *db_getfilename(void);
void db_connect(void);
void db_close(void);
int db_open(void);
float db_get_last_km(void);
float db_get_last_refill(void);
int db_get_monthly_data(int year, double *x, double *fill, double *trip, double *consum, double *priceperlitre);
float db_get_totalkm(void);
float db_get_totalfill(void);
float db_get_totalcost(void);
sqlite_int64 db_get_last_insert_rowid(void);
void db_get_driver(char *driver, int id, int n);
void db_get_current_driver(char *driver, int n);
int db_get_numof_drivers(void);
int db_get_numof_records(int id);
int db_get_numof_events(int id);
int db_get_numof_events_with_record(int id);
int db_get_numof_cars(void);
int db_get_numof_carrecords(int id);
int db_get_numof_carevents(int id);
int db_get_numof_alarmtypes(int id);
int db_delete_driver(int id);
int db_delete_car(int id);
void db_get_current_car(char *driver, int n);
int db_estimate_date(float km, char *estdate, int n, char *lastdate, double interval);
float db_estimate_km(char *lastdate, double interval);
void db_get_last_event(int alarmid, char *day, double *km, int n);
float db_get_max(int fieldnum);
float db_get_max_date(char *date, int n);
float db_get_min(int fieldnum);
float db_get_min_date(char *date, int n);
int db_events_exist(int alarmid);
void db_calc_date(char *newdate, char *date, double num, char *unit, int n);
int db_delete_events(int alarmid);
int db_delete_reminder(int id);
void fuelpad_exit(void);

#endif
