import hildon
import gtk


def hildon_gtk_window_set_progress_indicator(win, value):

    pass


class StackableWindow(hildon.Window):

    def __init__(self):
    
        self.__app_menu = None
    
        hildon.Window.__init__(self)
        self.set_size_request(600, 400)
        hildon.Window.fullscreen(self)
        
        self.__app_menu_window = gtk.Window(gtk.WINDOW_POPUP)
        self.__app_menu_window.set_modal(True)
        self.__app_menu_window.connect("button-press-event",
                                       self.__check_close_menu)


    def __check_close_menu(self, src, ev):
    
        px, py = src.get_pointer()
        nil, nil, w, h = self.__app_menu_window.get_allocation()
        if (py > h):
            self.hide_app_menu()
        
        
    def fullscreen(self):
    
        pass
        

    def unfullscreen(self):
    
        pass


    def set_app_menu(self, menu):
    
        if (self.__app_menu):
            self.__app_menu_window.remove(self.__app_menu)
            self.__app_menu = None
        
        if (menu):
            self.__app_menu = menu
            self.__app_menu_window.add(menu)

        
    def show_app_menu(self):
    
        if (self.__app_menu):
            w = 700 #int(gtk.gdk.screen_width() * 0.9)
            h = self.__app_menu.get_rows() * 80
            x = 50#(gtk.gdk.screen_width() - w) / 2
            self.__app_menu_window.move(x, 0)
            self.__app_menu_window.resize(w, h)
            print w, h
            self.__app_menu_window.show_all()


    def hide_app_menu(self):
    
        self.__app_menu_window.hide()



class AppMenu(gtk.Frame):

    def __init__(self):

        self.__items = []
        
        gtk.Frame.__init__(self)
        self.set_shadow_type(gtk.SHADOW_IN)
        self.__vbox = gtk.VBox(spacing = 2)
        self.__vbox.set_border_width(3)
        self.add(self.__vbox)
        
        self.__filter_box = gtk.HBox()
        self.__vbox.add(self.__filter_box)
        
        self.__current_item_box = None


    def get_rows(self):
    
        rows = 0
        if (self.__filter_box.get_children()):
            rows += 1
        rows += (len(self.__items) + 1) / 2
        
        return rows
              
        
    def append(self, item):
    
        if (not self.__current_item_box or
            len(self.__current_item_box.get_children()) == 2):
            self.__current_item_box = gtk.HBox(spacing = 2)
            self.__vbox.add(self.__current_item_box)
    
        self.__current_item_box.pack_start(item, False, False)
        self.__items.append(item)

        
    def add_filter(self, item):
    
        self.__filter_box.pack_start(item, True, False)


    def show_all(self):
    
        for item in self.__items:
            item.set_size_request(346, 70)
        for item in self.__filter_box.get_children():
            item.set_size_request(694 / len(self.__filter_box.get_children()), 70)
            
        gtk.Frame.show_all(self)


class GtkButton(gtk.Button):

    def __init__(self, size):
    
        gtk.Button.__init__(self)


class GtkRadioButton(gtk.RadioButton):

    def __init__(self, size, group):
    
        gtk.RadioButton.__init__(self, group = group)
        self.set_size_request(-1, 70)

