from ui.Window import Window
from ui.Button import Button
from ui.Label import Label
from ui.TextInput import TextInput
from ui.layout import HBox, VBox
from theme import theme
import platforms

import gtk




class InputDialog(Window):

    def __init__(self, title, label_ok = "OK", label_cancel = "Cancel"):
    
        self.__inputs = []
        self.__return_code = self.RETURN_CANCEL

        # list of value retrieving functions
        self.__retrievers = []
    
        Window.__init__(self, Window.TYPE_DIALOG)
        self.connect_closed(self.__on_close, self.RETURN_CANCEL)
        self.set_title(title)
        
        self.__button_ok = Button(label_ok)
        self.__button_ok.connect_clicked(self.__on_close, self.RETURN_OK)
        self.add(self.__button_ok)

        if (not platforms.MAEMO5):
            self.__button_cancel = Button(label_cancel)
            self.__button_cancel.connect_clicked(self.__on_close, self.RETURN_CANCEL)
            self.add(self.__button_cancel)

        
        self.__vbox = VBox()
        self.add(self.__vbox)
            

    def __on_close(self, return_code):
    
        self.__return_code = return_code
        self.set_visible(False)


    def render_this(self):
    
        x, y = self.get_screen_pos()
        w, h = self.get_size()
        screen = self.get_screen()
        
        screen.fill_area(x, y, w, h, theme.color_ui_background)

        if (not platforms.MAEMO5):
            self.__vbox.set_geometry(6, 0, w - 32, h - 80)
            self.__button_ok.set_geometry(w - 280, h - 60, 120, 60)
            self.__button_cancel.set_geometry(w - 150, h - 60, 120, 60)

        else:
            self.__vbox.set_geometry(6, 5, w - 165 - 12, h)
            self.__button_ok.set_geometry(w - 120, 5, 115, 60)
            
            


    def add_input(self, label, default):
      
        hbox = HBox()
        hbox.set_spacing(12)
        hbox.set_valign(hbox.VALIGN_CENTER)
        self.__vbox.add(hbox, True)
      
        lbl = Label(label, theme.font_ui_plain, theme.color_ui_text)
        hbox.add(lbl)
        
        entry = TextInput()
        hbox.add(entry, True)

        self.__retrievers.append(lambda :entry.get_text())

    """
    def add_range(self, label, min_value, max_value, preset):

        vbox = gtk.VBox()
        vbox.show()
        self.vbox.add(vbox)

        lbl = gtk.Label(label)
        lbl.set_alignment(0.0, 0.5)
        lbl.show()
        vbox.add(lbl)
    
        if (hildon):    
            scale = hildon.GtkHScale()
        else:
            scale = gtk.HScale()

        scale.set_range(min_value, max_value)
        scale.set_value(preset)
        scale.show()
        vbox.add(scale)
        self.__retrievers.append(lambda :scale.get_value())
    """

        
    def get_values(self):
    
        return [ r() for r in self.__retrievers ]


    def get_return_code(self):
    
        return self.__return_code




    def run(self):
    
        w = gtk.gdk.screen_width()
        h = min(gtk.gdk.screen_height() - 120, len(self.__retrievers) * 60)

        # add space for dialog buttons
        if (not platforms.MAEMO5):
            h += 80
            
        self.set_window_size(w, h)
        return Window.run(self)

