from com import Component, msgs

import dbus
import dbus.service


class DBusMonitor(Component, dbus.service.Object):
    """
    Component for controlling the application with a D-Bus interface.
    """

    def __init__(self):
    
        Component.__init__(self)
        dbus.service.Object.__init__(self,
                                     dbus.service.BusName("de.pycage.fmradio",
                                                          dbus.SessionBus()),
                                     "/de/pycage/fmradio")
    

    @dbus.service.method("de.pycage.fmradio")
    def start(self):
    
        self.emit_message(msgs.POLICY_EV_FMRADIO_ALLOWED)


    @dbus.service.method("de.pycage.fmradio")
    def stop(self):
    
        self.emit_message(msgs.POLICY_EV_FMRADIO_DISALLOWED)
