/*
 *  eCoach
 *
 *  Copyright (C) 2008  Jukka Alasalmi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#ifndef _ECG_VIEW_H
#define _ECG_VIEW_H

/* Configuration */
#include "config.h"

/* Gtk */
#include <gtk/gtk.h>

/* Other modules */
#include "ecg_data.h"
#include "gconf_helper.h"

typedef struct _EcgViewData
{
	GConfHelperData *gconf_helper;

	/* Add this widget to the container */
	GtkWidget *main_widget;

	/* Connect the "clicked" signal of this button */
	GtkWidget *btn_close;

	GtkWidget *drawing_area;
	GdkPixmap *pixmap;


	EcgData *ecg_data;

	gboolean is_drawing;

	/* Paint position */
	gint paint_position;
} EcgViewData;

EcgViewData *ecg_view_new(GConfHelperData *gconf_helper, EcgData *ecg_data);

void ecg_view_start_drawing(EcgViewData *self);
void ecg_view_stop_drawing(EcgViewData *self);

#endif /* _ECG_VIEW_H */
