from easy import bluetooth
from easy import ui

def find_devices(app, button):
    app['playlist'].clear()
    try:
        app.devices = bluetooth.finddevices()
        for dev in app.devices:
            mac, name, value = dev
            app['playlist'].append(name)
    except:
        pass

def send_file(app, button, value):
    rows = app['playlist'].selected()
    if rows:
        idx, row = rows[0]
        mac, name, id = app.devices[idx]
        # 1-Maemo 9-Phone
        try:
            mac, channel, service_name = bluetooth.findservices(mac, u'OBEX Object Push')[0]
            bluetooth.sendfile(mac, channel, value)
        except:
            pass
        
app = ui.App(title='Easy Bluetooth', 
                
                top = ui.Button(id='find_devices', label='Find devices', callback=find_devices),
                        
                center = ui.Table(id='playlist', label=None, show_headers=False, types=(str,)),

                bottom = ui.OpenFileButton(id='send_file', callback=send_file))

app.devices = []

ui.run()