#ifndef DICEEDIT_H
#define DICEEDIT_H

/*
  DiceJinni - A dice simulator
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

#include <Lum/Dialog.h>

#include "Configuration.h"

class ValuesModel : public Lum::Model::StdRefTable<Value,std::vector<Value> >
{
private:
  class DataProvider : public Lum::Model::StdRefTable<Value,std::vector<Value> >::DataProvider
  {
  public:
    std::wstring GetString(const Iterator& iter, size_t column) const
    {
      return iter->value;
    };
  };

public:
  ValuesModel(std::vector<Value>& list)
  : Lum::Model::StdRefTable<Value,std::vector<Value> >(list,new DataProvider())
  {
    // no code
  }
};

typedef Lum::Base::Reference<ValuesModel> ValuesModelRef;

class DiceEdit : public Lum::Dialog
{
private:
  Dice&                              dice;

  ValuesModelRef                     valuesModel;

  Lum::Model::SingleLineSelectionRef selection;

  Lum::Model::ActionRef              addAction;
  Lum::Model::ActionRef              editAction;
  Lum::Model::ActionRef              removeAction;

public:
  DiceEdit(Dice& dice);

  void PreInit();

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

#endif
