/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

enum {
	PROVIDER_COLUMN_DESCRIPTION,
	PROVIDER_COLUMN_TYPE,
	PROVIDER_COLUMN_DATA,
	PROVIDER_NUM_COLUMNS
};

enum {
	RESULT_COLUMN_THUMBNAIL,
	RESULT_COLUMN_DESCRIPTION,
	RESULT_COLUMN_DATA,
	RESULT_NUM_COLUMNS
};

typedef struct {
	GtkWidget *window;
	GtkWidget *search_entry;
	GtkWidget *statusbar;
	GtkWidget *progressbar;
	GtkWidget *providers_combo;
	GtkWidget *results_view;
	GtkUIManager *uimgr;
	GdkCursor *window_cursor;
	GSList *results_list;
} CFGui;

CFGui *ui_init (gpointer cb_data);
void ui_error_dialog (CFGui *, GError *);
void ui_set_save_enabled (CFGui *, gboolean);
void ui_push_status (CFGui *, const gchar *, const gchar *);
void ui_pop_status (CFGui *, const gchar *);
void ui_set_busy_begin (CFGui *);
void ui_set_busy_end (CFGui *);
void ui_select_search_entry (CFGui *);
void ui_progress_set (CFGui *, gdouble);
void ui_progress_reset (CFGui *);
