/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string.h>
#include <glib.h>
#include "search.h"

gint search_results_cmp (const SResult * a, const SResult * b)
{
	if (!strcmp (a->type, b->type)) {
		return (!strcmp (a->title, b->title));
	} else if (!strcmp (a->type, SRESULT_TYPE_CDDA)) {
		return -1;
	}

	return 1;
}

gchar *search_result_get_markup (SResult * result)
{
	GString *markup;

	markup = g_string_new ("<span size=\"larger\" weight=\"heavy\">");
	g_string_append (markup, result->title);
	g_string_append (markup, "</span>");

	if (result->artist != NULL) {
		g_string_append (markup, "\nby <i>");
		g_string_append (markup, result->artist);
		g_string_append (markup, "</i>");
	}
	if (result->type != NULL) {
		g_string_append (markup, "\n\n");
		g_string_append (markup, result->type);
	}

	return g_string_free (markup, FALSE);
}

SResult *search_result_new (void)
{
	return g_new0 (SResult, 1);
}

void search_result_free (SResult * p)
{
	if (p == NULL) {
		return;
	}

	g_free (p->title);
	g_free (p->artist);
	g_free (p->markup);
	g_free (p->image_url);
	g_free (p->image_file);
	g_free (p);
}
