/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

typedef struct {
	CFApp *app;
	const gchar *token;
} CFSearchData;

typedef struct {
	CFSearchData *search_data;
	GtkListStore *model;
	gint num_results;
	gint results_passed;
} CFResultData;

typedef struct {
	GError *err;
	gchar *filename;
	guint items_saved;
} CFSaveData;

gpointer cf_search (gpointer);
gpointer cf_clear_cache (gpointer);
void cf_quit (CFApp *);
void cf_show_about_dialog (CFApp *);
void cf_save_selected (CFApp *);
