/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <gtk/gtk.h>

#include "ui.h"
#include "coverfinder.h"
#include "control.h"

void cb_window_delete (GtkWidget * widget, GdkEvent * event, gpointer data)
{
	cf_quit ((CFApp *) data);
}

void cb_search (GtkEntry * entry, gpointer data)
{
	CFSearchData *search_data;
	CFApp *app = (CFApp *) data;
	GError *err = NULL;

	search_data = g_new (CFSearchData, 1);
	search_data->token = gtk_entry_get_text (entry);
	search_data->app = app;
	if (g_thread_create (cf_search, search_data, FALSE, &err) == NULL) {
		ui_error_dialog (app->gui, err);
		g_free (search_data);
		g_error_free (err);
	}
}

void cb_action_quit (GtkAction * action, gpointer data)
{
	cf_quit ((CFApp *) data);
}

void cb_action_info (GtkAction * action, gpointer data)
{
	cf_show_about_dialog ((CFApp *) data);
}

void cb_action_save (GtkAction * action, gpointer data)
{
	cf_save_selected ((CFApp *) data);
}

gboolean cb_result_selected (GtkTreeSelection * selection, gpointer data)
{
	GtkTreeIter iter;
	CFApp *app = (CFApp *) data;
	CFGui *gui = app->gui;

	if (gtk_tree_selection_get_selected (selection, NULL, &iter)) {
		ui_set_save_enabled (gui, TRUE);
	} else {
		ui_set_save_enabled (gui, FALSE);
	}
	return TRUE;
}

void cb_action_clear_cache (GtkAction * action, gpointer data)
{
	CFApp *app = (CFApp *) data;
	GError *err = NULL;

	if (g_thread_create (cf_clear_cache, data, FALSE, &err) == NULL) {
		ui_error_dialog (app->gui, err);
		g_error_free (err);
	}
}

gboolean cb_result_button_pressed (GtkWidget * widget, GdkEventButton * event, gpointer data)
{
	CFApp *app = (CFApp *) data;
	CFGui *gui = app->gui;
	GtkWidget *menu;

	if (event->button == 3) {
		menu = gtk_ui_manager_get_widget (gui->uimgr, "/ResultPopup");
		gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, data, event->button,
						gtk_get_current_event_time ());
	}
	return FALSE;
}
