/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
 
#ifndef CONTACTINFOS_H
#define CONTACTINFOS_H

#include <glib.h>

#define CONTACTINFOS_DBUS_NAME 				"com.nokia.contactinfos"
#define CONTACTINFOS_DBUS_PATH 				"/com/nokia/contactinfos"
#define CONTACTINFOS_DBUS_INTERFACE 			"com.nokia.contactinfos"
#define CONTACTINFOS_DBUS_RESULTS_SIGNAL 		"resultsAvailable"

#define CONTACTINFOS_GCONF_KEY			 		"/apps/contactinfos/backendModule"

typedef enum {
	CI_FULL_ADDRESS 			= 1 << 0,
	CI_GPS_COORDINATE 		= 1 << 1,
	CI_CITY 					= 1 << 2,
	CI_POST_CODE 				= 1 << 3,
	CI_ADDRESS 				= 1 << 4,
	CI_PHONE_NUMBER 			= 1 << 5,
	CI_MOBILE_PHONE_NUMBER 	= 1 << 6,
	CI_FAX_PHONE_NUMBER 		= 1 << 7,
	CI_NAME					= 1 << 8,
	CI_COMPANY				= 1 << 9,
	CI_VALUE_TYPE				= 1 << 10,
	CI_EMAIL					= 1 << 11,
	CI_WEB					= 1 << 12
} ContactinfosInfos;
#define CI_NOTHING 0
#define CI_ALL_PHONE_NUMBER (CI_PHONE_NUMBER | CI_MOBILE_PHONE_NUMBER | CI_FAX_PHONE_NUMBER)
#define CI_EVERYTHING (CI_FULL_ADDRESS | CI_GPS_COORDINATE | CI_CITY | CI_POST_CODE | CI_ADDRESS | CI_ALL_PHONE_NUMBER | CI_NAME | CI_COMPANY | CI_VALUE_TYPE | CI_EMAIL | CI_WEB)


#define CI_WORK_PHONE 	"wp"
#define CI_HOME_PHONE 	"hp"
#define CI_WORK_MOBILE 	"wm"
#define CI_HOME_MOBILE 	"hm"
#define CI_WORK_FAX 		"wf"
#define CI_HOME_FAX 		"hf"
#define CI_WORK_ADDRESS 	"wa"
#define CI_HOME_ADDRESS 	"ha"
#define CI_WORK_EMAIL	 	"we"
#define CI_HOME_EMAIL	 	"he"
#define CI_NAME_STR	 	"na"
#define CI_COMPANY_STR 	"co"

#define CI_LAST_ELEMENT_ID 	0
#define CI_LAST_VALUE_ID 	0

typedef enum {
	CI_BACKEND_INITIALIZE_ERROR = -10,
	CI_BACKEND_LOAD_MODULE_ERROR,
	CI_BACKEND_LOAD_SYMBOL_ERROR,
	CI_BACKEND_ACCESS_ERROR,
	CI_BACKEND_UNLOAD_MODULE_ERROR,
	CI_BACKEND_TERMINATE_ERROR,
	CI_NO_ERROR	= 0,
	CI_NOT_FOUND,
	CI_FOUND_BUT_NO_DISPLAY,
	CI_FOUND_BUT_UPPER_LIMIT_REACHED
} ContactinfosErrorCodes;

/* struct for the response */
typedef struct _ContactInfosElement ContactInfosElement;
struct _ContactInfosElement {
	gchar *name;
	gchar *company;
	GPtrArray *valueArray;
};

typedef struct _ContactInfosValue ContactInfosValue;
struct _ContactInfosValue {
	guint typeInfo;
	gchar *type;
	gchar *value;
};

#endif
