/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_UI_H
#define _CONLER_UI_H

#include "types.h"
#include "appdata.h"

#include <gtk/gtk.h>
#include <glib/gslist.h>

#define ENB_SUPERUSER_ENV_STOCK "enabled-superuser-env"
#define DSB_SUPERUSER_ENV_STOCK "disabled-superuser-env"
#define ENB_BG_COMMAND_STOCK "enabled-bg-command"
#define DSB_BG_COMMAND_STOCK "disabled-bg-command"
#define ENB_FG_COMMAND_STOCK "enabled-fg-command"
#define DSB_FG_COMMAND_STOCK "disabled-fg-command"

AppData_s*  new_app_data();
void        free_app_data(AppData_s*);

void    create_main_view(AppData_s*);
void    create_ap_list_view(AppData_s*);
void    fill_ap_list_view(AppData_s*);
void    create_cmd_list_view(AppData_s*);
void    fill_cmd_list_view(GtkListStore*, GSList*);

void    enable_cmd_toolbuttons(AppData_s*, gboolean);
void    enable_ap_general_toolbuttons(AppData_s*, gboolean);

// TODO: move to utils?
void select_treeview_row(GtkWidget*, GtkTreeIter*);

gboolean show_add_command_dialog(GtkWindow*, GtkTreeModel*,
				 const gboolean, Command_s**);
gboolean show_add_ap_dialog(GtkWindow*, const gboolean, AccessPoint_s**);

// TODO: move to utils?
#define DECLARE_GET_XXX_SLIST_FROM_MODEL_FUNC(TYPENAME) \
  GSList* get_ ## TYPENAME ## _gslist_from_model(GtkTreeModel*)

#define DECLARE_INVERSE_XXX_FIELD_FUNC(NAME, FIELD) \
  void inverse_ ## NAME ## _ ## FIELD ##_field(gchar*, gpointer, gboolean*)

DECLARE_GET_XXX_SLIST_FROM_MODEL_FUNC(cmd);
DECLARE_GET_XXX_SLIST_FROM_MODEL_FUNC(ap);

DECLARE_INVERSE_XXX_FIELD_FUNC(cmd, disabled);
DECLARE_INVERSE_XXX_FIELD_FUNC(cmd, superuser_env);
DECLARE_INVERSE_XXX_FIELD_FUNC(ap, disabled);

#endif

