/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#include "ui.h"
#include "slots.h"
#include "common.h"
#include "types.h"
#include "const.h"
#include "appdata.h"
#include "debug.h"

#include <glib/gstdio.h>
#include <glib/gmem.h>

#include <gtk/gtk.h>

#ifdef MAEMO
  #include <libosso.h>
#endif

#ifdef NOTIFY_MAJOR_CHANGES
void notify_major_changes()
{
    static char* msg = "New 'conler' version contains "
	               "major changes. Please check your "
	               "configuration before using.";
    GtkWidget* notify_dialog = gtk_message_dialog_new(
	                            NULL,
				    GTK_DIALOG_DESTROY_WITH_PARENT,
				    GTK_MESSAGE_INFO,
				    GTK_BUTTONS_OK,
				    msg);

    g_signal_connect(notify_dialog, "response",
 		      G_CALLBACK(gtk_main_quit), NULL);
    gtk_widget_show_all(notify_dialog);

    gtk_main();

    gtk_widget_destroy(notify_dialog);
}
#endif


int main(int argc, char** argv)
{
    ConlerCfg_s cfg;
    AppData_s* app_data;

// NOTE: this functionality should be used when new program's
//       version brings major changes which can change default
//       program's behaviour

// NOTE: dirty, but native glib's command line
//       parsing approach will be overhead here
    if (2 == argc) {
	gint index = argc - 1;

#ifdef NOTIFY_MAJOR_CHANGES
  #define NOTIFY_SUPPORT "true"
#else
  #define NOTIFY_SUPPORT "false"
#endif
	gchar* notify_support = NOTIFY_SUPPORT;

	if (!g_ascii_strcasecmp(argv[index], "-support-notify-major-changes")) {
	    g_print("%s\n", notify_support);
	    return 0;
	}
#ifdef NOTIFY_MAJOR_CHANGES
	else if (!g_ascii_strcasecmp(argv[index], "-notify-major-changes")) {
	    gtk_init(&argc, &argv);
	    notify_major_changes();
	    return 0;
	}
#endif
    }

    gtk_init(&argc, &argv);

    g_set_application_name(PROGRAM_FULL_ID);
    app_data = new_app_data();

#ifdef MAEMO
    app_data->osso_context = osso_initialize(OSSO_SERVICE_NAME,
					     PROGRAM_VERSION,
					     FALSE, NULL);
    g_assert(NULL != app_data->osso_context);
#endif

    // TODO: create a new configuration file if doesn't exist
    // TODO: accept an alternative path to configuration file
    CfgReadResult cfg_read_result = read_cfg(CONFIG_PATH, &cfg);
    DBG("Cfg. open status = %d", cfg_read_result);
    if (CFG_R_OK != cfg_read_result && CFG_R_OPEN_ERR != cfg_read_result) {
        const gchar* msg = "Can't read '%s', error: %s.\nUsing new empty one";
        const gchar* err = CFG_READ_STATUS[cfg_read_result];
        GtkWidget* config_warn_dialog = gtk_message_dialog_new(NULL,
                                                        GTK_DIALOG_MODAL,
                                                        GTK_MESSAGE_WARNING,
                                                        GTK_BUTTONS_OK,
                                                        msg,
                                                        CONFIG_PATH, err);

        gtk_window_set_title(GTK_WINDOW(config_warn_dialog), PROGRAM_ID " warning");
        gtk_dialog_run(GTK_DIALOG(config_warn_dialog));
        gtk_widget_destroy(config_warn_dialog);
    }

    app_data->access_points = cfg.access_points;

    create_main_view(app_data);
    create_ap_list_view(app_data);
    fill_ap_list_view(app_data);
    create_cmd_list_view(app_data);
    enable_cmd_toolbuttons(app_data, FALSE);
//    enable_ap_general_toolbuttons(app_data, FALSE);

    connect_signals(app_data);
    gtk_widget_show_all(GTK_WIDGET(app_data->mainWindow));

    gtk_main();

#ifdef MAEMO
    osso_deinitialize(app_data->osso_context);
#endif
    free_app_data(app_data);
    free_cfg(&cfg);

    return 0;
}

