/*
 * Copyright (C) 2008, 2009 Andrew Sichevoi.
 *
 * This file is part of Conler (http://thekondor.net/conler).
 *
 * Conler is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conler. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONLER_TYPES_H
#define _CONLER_TYPES_H

#include <glib/gslist.h>

#ifdef CONLER_GUI
    // GType definition
    #include <glib-object.h>
#endif

typedef enum
{
    UNKNOWN_VERSION = 0,
    CHINOOK,
    DIABLO
} MaemoVersion;

typedef enum
{
    CFG_R_OK = 0,
    CFG_R_OPEN_ERR,
    CFG_R_EMPTF_ERR,
    CFG_R_WRGT_ERR
} CfgReadResult;

typedef struct
{
    gchar* version; 
    GSList* access_points;   // List of Wi-Fi Access Points

} ConlerCfg_s;


typedef struct
{
    gchar* name;
    gboolean disabled;
    GSList* commands;

} AccessPoint_s;

typedef struct
{
    gchar* command;
    gboolean disabled;
    gboolean superuser_env;

} Command_s;

#ifdef CONLER_GUI
  #define ACCESS_POINT_TYPE   access_point_get_type()
  GType access_point_get_type();

  #define COMMAND_TYPE        command_get_type()
  GType command_get_type();
#endif


#endif

