#!/bin/sh

RSS_URL=http://www.flourish.org/news/flickr-daily-interesting-one.xml

LOCK=`date +%F`.lock

error()
{
    echo $@
    exit 1
}

STORE_DIR=$1
STORE_YEST_DIR=$1/yesterday
test -z "$1" && error "No store dir is provided"
test -f "$STORE_DIR/$LOCK" && error "Already updated"

# Create store directories
test ! -d "$1" && (mkdir "$STORE_DIR"; mkdir "$STORE_YEST_DIR")

# Save yesterday's photos
rm -rf "$STORE_YEST_DIR"/*
mv "$STORE_DIR"/* "$STORE_YEST_DIR"

RSS=`/bin/tempfile`
wget $RSS_URL -O $RSS

for photo in `/bin/grep -o 'http://static.flickr.com.*jpg' $RSS`; do
    wget $photo -O $STORE_DIR/`basename $photo` &
done

rm -f $RSS
touch $STORE_DIR/$LOCK

