// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#include "common.h"
#include "appdata.h"
#include "types.h"
#include "ui.h"
#include "ui-utils.h"
#include "debug.h"
#include "cellrendererpixbuf.h"

#include <gtk/gtk.h>

#ifdef MAEMO
  #include <hildon/hildon.h>
#endif

// TODO: wrap to translation macroses
// TODO: set GTK_SELECTION_BROWSE to all views -> remove checks for selection
//                                                and toolbuttons disabling
/*
#define GETTEXT_PACKAGE "gtk20"
#include <glib/gi18n-lib.h>
*/

#define W(wdg)  app_data->wdg

static void create_ap_toolbar(GtkWidget*, AppData_s*);
static void create_cmd_toolbar(GtkWidget*, AppData_s*);
static void create_main_toolbar(GtkWidget*, AppData_s*);


AppData_s* new_app_data()
{
    AppData_s* app_data = g_new(AppData_s, 1);

    W(ap.currentIter) = NULL;
    W(changed) = FALSE;
    W(cmd.changed) = FALSE;
#ifdef MAEMO
    W(fullscreen) = FALSE;
#endif

    return app_data;
}

void free_app_data(AppData_s* app_data)
{
    if (!app_data)
        return;

    if (W(ap.currentIter))
        gtk_tree_iter_free(W(ap.currentIter));

    g_free(app_data);
}

void create_main_view(AppData_s* app_data)
{
    GtkWidget* hpaned = gtk_hpaned_new();
    GtkWidget* left_frame = gtk_frame_new("");
    GtkWidget* right_frame = gtk_frame_new("");
    GtkWidget* main_vbox = gtk_vbox_new(FALSE, 0);
    GtkWidget* toolbar_hbox = gtk_hbox_new(FALSE, 0);

    /* Main Window */
#ifdef MAEMO
    W(program) = HILDON_PROGRAM(hildon_program_get_instance());
    W(mainWindow) = HILDON_WINDOW(hildon_window_new());
#else
    W(mainWindow) = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#endif

    gtk_container_set_border_width(GTK_CONTAINER(W(mainWindow)), 10);
    gtk_window_set_default_size(GTK_WINDOW(W(mainWindow)), 700, 300);
    gtk_container_add(GTK_CONTAINER(W(mainWindow)), main_vbox);

    /* Frames */
    gtk_box_pack_start(GTK_BOX(main_vbox), hpaned, TRUE, TRUE, 0);
    gtk_paned_add1(GTK_PANED(hpaned), left_frame);
    gtk_paned_add2(GTK_PANED(hpaned), right_frame);

    /* AP List */
    W(apListView) = gtk_tree_view_new();
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(W(apListView)), FALSE);
    gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(W(apListView)), FALSE);
    gtk_container_add(GTK_CONTAINER(left_frame), W(apListView));

    /* Command List */
    W(commandListView) = gtk_tree_view_new();
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(W(commandListView)), FALSE);
    gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(W(commandListView)), FALSE);
    gtk_container_add(GTK_CONTAINER(right_frame), W(commandListView));

    /* Toolbar */
    gtk_box_pack_end(GTK_BOX(main_vbox), toolbar_hbox, FALSE, TRUE, 0);
    create_ap_toolbar(toolbar_hbox, app_data);
    create_cmd_toolbar(toolbar_hbox, app_data);
    create_main_toolbar(toolbar_hbox, app_data);

#ifdef MAEMO
    hildon_program_add_window(W(program), W(mainWindow));
#endif
}

static void create_ap_toolbar(GtkWidget* toolbar_hbox, AppData_s* app_data)
{
    GtkWidget* toolbar = gtk_toolbar_new();
    GtkToolItem* tool_button_sep = NULL;

    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
#ifdef MAEMO
    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_LARGE_TOOLBAR);
#endif
//    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_BUTTON);
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);  

    W(ap.disableToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_CONNECT);
    W(ap.addToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_ADD);
    W(ap.delToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_REMOVE);
    W(ap.renameToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_CONVERT);
    tool_button_sep = gtk_separator_tool_item_new();

    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.disableToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.addToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.delToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(ap.renameToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), tool_button_sep, -1);

    gtk_box_pack_start(GTK_BOX(toolbar_hbox), toolbar, TRUE, TRUE, 0);
    //hildon_window_add_toolbar(W(mainWindow), GTK_TOOLBAR(toolbar));
    //
    /*
    GtkWidget* button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_button_set_label(GTK_BUTTON(button), "");
    gtk_box_pack_start(GTK_BOX(toolbar_hbox), button, TRUE, TRUE, 0); */
}

static void create_cmd_toolbar(GtkWidget* toolbar_hbox, AppData_s* app_data)
{
    GtkWidget* toolbar = gtk_toolbar_new();

    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
#ifdef MAEMO
    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_LARGE_TOOLBAR);
#endif
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);  

    W(cmd.editToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_EDIT);
    W(cmd.moveUpToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_GO_UP);
    W(cmd.moveDownToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_GO_DOWN);
    W(cmd.addToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_NEW); 
    W(cmd.delToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_DELETE);

    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.editToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.moveUpToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.moveDownToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.addToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(cmd.delToolButton), -1);

    gtk_box_pack_start(GTK_BOX(toolbar_hbox), toolbar, TRUE, TRUE, 0);
    //hildon_window_add_toolbar(W(mainWindow), GTK_TOOLBAR(toolbar));

}

static void create_main_toolbar(GtkWidget* toolbar_hbox, AppData_s* app_data)
{
    GtkWidget* toolbar = gtk_toolbar_new();
    GtkToolItem* empty_tool_item = gtk_tool_item_new();

    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
#ifdef MAEMO
    gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar), GTK_ICON_SIZE_LARGE_TOOLBAR);
#endif
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);

    W(applyToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_APPLY);
    W(quitToolButton) = gtk_tool_button_new_from_stock(GTK_STOCK_QUIT);

    gtk_tool_item_set_expand(empty_tool_item, TRUE);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), empty_tool_item, -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(applyToolButton), -1);
    gtk_toolbar_insert(GTK_TOOLBAR(toolbar), W(quitToolButton), -1);

    gtk_box_pack_end(GTK_BOX(toolbar_hbox), toolbar, TRUE, TRUE, 0);
    //hildon_window_add_toolbar(W(mainWindow), GTK_TOOLBAR(toolbar));

}

/* Access Points */
static void active_ap_cell_func(GtkTreeViewColumn* column,
                                GtkCellRenderer* cell,
                                GtkTreeModel* model,
                                GtkTreeIter* iter,
                                gpointer data)
{
    AccessPoint_s* ap;

    gtk_tree_model_get(model, iter, 0, &ap, -1);
    SET_STOCK_ICON(cell, ap->disabled, NO, YES);

    free_access_point(ap);
}

static void name_ap_cell_func(GtkTreeViewColumn* column,
                              GtkCellRenderer* cell,
                              GtkTreeModel* model,
                              GtkTreeIter* iter,
                              gpointer data)
{
    AccessPoint_s* ap;

    gtk_tree_model_get(model, iter, 0, &ap, -1);
    g_object_set(cell, "text", ap->name, NULL);

    free_access_point(ap);
}

void create_ap_list_view(AppData_s* app_data)
{
    GtkListStore* list_store;
    GtkTreeSelection* selection;

    W(ap.enabledCellRndr) = cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(apListView)),
                                     -1,
                                     "Active",
                                     W(ap.enabledCellRndr),
                                     (GtkTreeCellDataFunc)active_ap_cell_func,
                                     NULL, NULL);

    W(ap.nameCellRndr) = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(apListView)),
                                     -1,
                                     "Name",
                                     W(ap.nameCellRndr),
                                     (GtkTreeCellDataFunc)name_ap_cell_func,
                                     NULL, NULL);

    list_store = gtk_list_store_new(1, ACCESS_POINT_TYPE);
    gtk_tree_view_set_model(GTK_TREE_VIEW(W(apListView)),
                            GTK_TREE_MODEL(list_store));

    /* Forbid to make a zero selection */
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(W(apListView)));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);

    g_object_unref(list_store);
}

void fill_ap_list_view(AppData_s* app_data)
{
    GtkListStore* list_store;

    list_store = GTK_LIST_STORE(gtk_tree_view_get_model(
                                    GTK_TREE_VIEW(W(apListView))));

    for (GSList* iter = W(access_points); iter;
                                          iter = g_slist_next(iter)) {
        GtkTreeIter ap_iter;

        gtk_list_store_append(list_store, &ap_iter);
        gtk_list_store_set(list_store, &ap_iter, 0, iter->data, -1);
    }

}

/* Commands */
static void cmdline_cell_func(GtkTreeViewColumn* column,
                              GtkCellRenderer* cell,
                              GtkTreeModel* model,
                              GtkTreeIter* iter,
                              gpointer data)
{
    gchar* cmd;

    gtk_tree_model_get(model, iter, 0, &cmd, -1);
    g_object_set(cell, "text", cmd, NULL);

    g_free(cmd);
}

static void down_cmdline_cell_func(GtkTreeViewColumn* column,
                                   GtkCellRenderer* cell,
                                   GtkTreeModel* model,
                                   GtkTreeIter* iter,
                                   gpointer data)
{
    gboolean next = is_next_tree_iter_sibling(model, iter);

    g_object_set(cell, "stock-id", next ? GTK_STOCK_GO_DOWN : 0, NULL);
}

static void up_cmdline_cell_func(GtkTreeViewColumn* column,
                                 GtkCellRenderer* cell,
                                 GtkTreeModel* model,
                                 GtkTreeIter* iter,
                                 gpointer data)
{
    gboolean prev = is_prev_tree_iter_sibling(model, iter);

    g_object_set(cell, "stock-id", prev ? GTK_STOCK_GO_UP : 0, NULL);
}


void create_cmd_list_view(AppData_s* app_data)
{
    GtkListStore* list_store;
    GtkTreeViewColumn* column;

    W(cmd.cmdlineCellRndr) = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(commandListView)),
                                      -1,
                                      "Command",
                                      W(cmd.cmdlineCellRndr),
                                      (GtkTreeCellDataFunc)cmdline_cell_func,
                                      NULL, NULL);

    g_object_set(G_OBJECT(W(cmd.cmdlineCellRndr)), "is-expanded", TRUE, NULL);
    column = gtk_tree_view_get_column(GTK_TREE_VIEW(W(commandListView)), 0);
    gtk_tree_view_column_set_expand(column, TRUE);

    W(cmd.downLineCellRndr) = cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(commandListView)),
                                    -1,
                                   "Move down",
                                    W(cmd.downLineCellRndr),
                                    (GtkTreeCellDataFunc)down_cmdline_cell_func,
                                    NULL, NULL);

    W(cmd.upLineCellRndr) = cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_data_func(GTK_TREE_VIEW(W(commandListView)),
                                      -1,
                                      "Move up",
                                      W(cmd.upLineCellRndr),
                                      (GtkTreeCellDataFunc)up_cmdline_cell_func,
                                      NULL, NULL);

    list_store = gtk_list_store_new(1, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(W(commandListView)),
                            GTK_TREE_MODEL(list_store));
    
    g_object_unref(list_store);
}

// TODO: more appropriate name, e.g. 'fill_cmd_list_store'
void fill_cmd_list_view(GtkListStore* store, GSList* commands)
{
    gtk_list_store_clear(store);

    for (GSList* iter = commands; iter; iter = g_slist_next(iter)) {
        GtkTreeIter cmd_iter;

        gtk_list_store_append(store, &cmd_iter);
        debug_msg(" cmd = %s\n", (gchar *)(iter->data));
        gtk_list_store_set(store, &cmd_iter, 0, iter->data, -1);
    }
}

#define DEFINE_GET_XXX_GSLIST_FROM_MODEL_FUNC(TYPENAME, TYPE)       \
GSList* get_ ## TYPENAME ## _gslist_from_model(GtkTreeModel* model) \
{                                                                   \
    GtkTreeIter iter;                                               \
    GSList* list = NULL;                                            \
                                                                    \
    if (!gtk_tree_model_get_iter_first(model, &iter))               \
        return NULL;                                                \
                                                                    \
    do {                                                            \
        TYPE* value = NULL;                                         \
                                                                    \
        gtk_tree_model_get(model, &iter, 0, &value, -1);            \
        APPEND2SLIST(list, value);                                  \
                                                                    \
    } while (gtk_tree_model_iter_next(model, &iter));               \
                                                                    \
    return list;                                                    \
}                                                                   

DEFINE_GET_XXX_GSLIST_FROM_MODEL_FUNC(cmd, gchar)
DEFINE_GET_XXX_GSLIST_FROM_MODEL_FUNC(ap, AccessPoint_s)


void enable_cmd_toolbuttons(AppData_s* app_data, gboolean enable)
{
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.moveUpToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.moveDownToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.addToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.delToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(cmd.editToolButton)), enable);
}

/* Only 'add' button should always be enabled */
void enable_ap_general_toolbuttons(AppData_s* app_data, gboolean enable)
{
    gtk_widget_set_sensitive(GTK_WIDGET(W(ap.delToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(ap.disableToolButton)), enable);
    gtk_widget_set_sensitive(GTK_WIDGET(W(ap.renameToolButton)), enable); 
}

void select_treeview_row(GtkWidget* tree_view, GtkTreeIter* iter)
{
    GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(tree_view));
    GtkTreePath* path = gtk_tree_model_get_path(model, iter);

    debug_msg("select-tree-view-row()");
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(tree_view), path, NULL, FALSE);

    gtk_tree_path_free(path);
}


