// (c) 2008, Andrew V. Sichevoi
// http://thekondor.net/conler

#include "cellrendererpixbuf.h"

#include <gtk/gtkmarshal.h>
#include <gtk/gtkprivate.h>

static void cell_renderer_pixbuf_init(CellRendererPixbuf* cell_pixbuf);
static void cell_renderer_pixbuf_class_init(CellRendererPixbufClass* klass);
static void cell_renderer_pixbuf_finalize(GObject* gobject);
static gint cell_renderer_pixbuf_activate(GtkCellRenderer*,
                                          GdkEvent*,
                                          GtkWidget*,
                                          const gchar*,
                                          GdkRectangle*,
                                          GdkRectangle*,
                                          GtkCellRendererState);


enum
{
  ACTIVATED,
  LAST_SIGNAL
};

static guint activate_cell_signals[LAST_SIGNAL] = { 0 };
static gpointer parent_class = NULL;

G_DEFINE_TYPE(CellRendererPixbuf, cell_renderer_pixbuf, GTK_TYPE_CELL_RENDERER_PIXBUF);

static void cell_renderer_pixbuf_init(CellRendererPixbuf* cell_pixbuf)
{
  // empty
}

static void cell_renderer_pixbuf_class_init(CellRendererPixbufClass* klass)
{
    GtkCellRendererClass* cell_class = GTK_CELL_RENDERER_CLASS(klass);
    GObjectClass* object_class = G_OBJECT_CLASS(klass);
    parent_class = g_type_class_peek_parent(klass);

    object_class->finalize = cell_renderer_pixbuf_finalize;
    cell_class->activate = cell_renderer_pixbuf_activate;

    /* Installing a new signal */
    activate_cell_signals[ACTIVATED] =
       g_signal_new ("activate",
		  G_OBJECT_CLASS_TYPE (object_class),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (CellRendererPixbufClass, activate),
		  NULL, NULL,
		  g_cclosure_marshal_VOID__STRING,
		  G_TYPE_NONE, 1,
		  G_TYPE_STRING);
}

static void cell_renderer_pixbuf_finalize(GObject* object)
{
    CellRendererPixbuf* self;

    g_return_if_fail(object != NULL);
    g_return_if_fail(CELL_RENDERER_PIXBUF(object));

    self = CELL_RENDERER_PIXBUF(object);
    G_OBJECT_CLASS(parent_class)->finalize(object);
}


GtkCellRenderer* cell_renderer_pixbuf_new(void)
{
    CellRendererPixbuf* self = g_object_new(TYPE_CELL_RENDERER_PIXBUF, NULL);

    return GTK_CELL_RENDERER(self);
}


static gint cell_renderer_pixbuf_activate(GtkCellRenderer* cell,
                                          GdkEvent* event,
                                          GtkWidget* widget,
                                          const gchar* path,
                                          GdkRectangle* background_area,
                                          GdkRectangle* cell_area,
                                          GtkCellRendererState flags)
{
    gboolean stock_icon_id;

    g_object_get(GTK_CELL_RENDERER_PIXBUF(cell), "stock_id",
                                          &stock_icon_id, NULL);
    if (!stock_icon_id || !event)
        return FALSE;

    g_signal_emit (cell, activate_cell_signals[ACTIVATED], 0, path);
    return TRUE;
}
                                                

