#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{TripsView}.

@todo: Document this module.
"""

import edje

class TripsView(edje.Edje):
    """
    @todo: Document this class.
    """
    def __init__(self, canvas, theme):
        edje.Edje.__init__(self, canvas, file=theme, group="trips")
        self.size = canvas.size

    def update_zoom_buttons(self, up, down):
        if up:
            self.signal_emit("enable-zoom-up", "")
        else:
            self.signal_emit("disable-zoom-up", "")
        if down:
            self.signal_emit("enable-zoom-down", "")
        else:
            self.signal_emit("disable-zoom-down", "")

    def scale_set(self, min, max):
        step = (max - min) / 5
        self.part_text_set("guide_zero_label", "%d" % min)
        self.part_text_set("guide_max_label", "%d" % max)
        for i in range(1, 5):
            self.part_text_set("guide%d_label" % i, "%d" % (min + step * i))

    def value_set_speed(self, metric):
        if metric:
            speed_label = "Speed (Km/h)"
        else:
            speed_label = "Speed (MPH)"
        self.part_text_set("y_bar_label", speed_label)

    def value_set_rpm(self):
        self.part_text_set("y_bar_label", "RPM (x100)")

    def value_set_altitude(self):
        self.part_text_set("y_bar_label", "ALTITUDE")

    def loaded_trip(self, current=False):
        if current:
            self.part_text_set("title", "CURRENT TRIP")
        else:
            self.part_text_set("title", "TRIPS")
