#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{TripListView}.

@todo: Document this module.
"""

import os


from common.carlog import DEBUG
from main.listctrl import ListView
from models.tripsmodel import TripsModel
from models.dbusmodel import CarmandDbusModel

class TripListView(ListView):
    """
    @todo: Document this class.
    """
    def __init__(self, title, cb, show_current=False):
        trips = []
        self.show_current = show_current
        self.cb = callable(cb) and cb or None
        ListView.__init__(self, "list-normal", "list-item-tag", title)

        self.trips_model = TripsModel()
        self.__load_trips()

    def show(self):
        for trip in self.trips:
            self.add_item(trip[0], self.cb, trip[2], tag=trip[1])

        ListView.show(self)

    def is_empty(self):
        return len(self.trips) == 0

    def __load_trips(self):
        self.trips = []
        trips_folder = CarmandDbusModel().GetTripsFolder()
        if not os.path.exists(trips_folder):
            return

        trip_current = self.trips_model.ActualTripFolder()
        paths = os.listdir(trips_folder)
        paths.sort()

        for path in paths:
            trip = os.path.join(trips_folder, path)
            info = self.trips_model.get_trip_info(trip)
            if info:
                if trip != trip_current:
                    if not info[0]:
                        info[0] = "<color>(No label)"
                    self.trips.append(info)
                elif self.show_current:
                    info[0] = "Current"
                    self.trips.append(info)

        self.trips.reverse()
