#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{StatsView}.

@todo: Document this module.
"""

import datetime

from main.listctrl import ListView
from common.carmanconfig import CarmanConfig, METRIC
from models.tripsmodel import TripsModel

class StatsView(ListView):
    """
    @todo: Document this class.
    """
    def __init__(self):
        self.labels = []
        self.model = TripsModel()
        ListView.__init__(self, "list-normal", "list-item-normal", "STATS")
        self.signal_callback_add("button-back-pressed", "",
                     self.__remove_callback)

        for i in range(11):
            self.labels.append(self.add_item("", None))

        if self.model.is_current():
            self.set_values(True)
            self.model.add_data_update_cb(self.__update)
        else:
            self.set_values(False)

    def __remove_callback(self, *param):
        self.labels = []
        self.model.del_data_update_cb(self.__update)

    def __get_total_time(self, total_time):
        h, r = divmod(total_time, 3600)
        m, s = divmod(r, 60)
        return "%02d:%02d:%02d" % (h, m, s)

    def set_values(self, current):
        metric = CarmanConfig().get_unit() == METRIC
        times = self.model.get_times()
        start_time = datetime.datetime.fromtimestamp(times[0])
        finish_time = datetime.datetime.fromtimestamp(times[1])
        total_time = self.__get_total_time(times[2])
        speed_stats = self.model.get_speed_stats()
        distance = self.model.get_trip_distance()
        if distance:
            distance = self.__format_distance(distance, metric)
        if speed_stats:
            speed_stats = self.__format_speed(speed_stats, metric)
        else:
            speed_stats = (None, None, None)
        rpm_stats = self.model.get_rpm_stats()
        if not rpm_stats:
            rpm_stats = (None, None, None)
        altitude_stats = self.model.get_altitude_stats()
        if altitude_stats:
            altitude_stats = ('%.2f' % altitude_stats[0], \
                    '%.2f' % altitude_stats[1], \
                    '%.2f' % altitude_stats[2])
        else:
            altitude_stats = ('None', 'None', 'None')

        finish_time = "Current Trip" if current else \
                finish_time.strftime("%d/%m/%Y %H:%M:%S")

        stats = [('Start', start_time.strftime("%d/%m/%Y %H:%M:%S")),
                ('Stop', finish_time),
                ('Time', total_time),
                ('Distance', distance),
                ('Average speed', speed_stats[2]),
                ('Max speed', speed_stats[1]),
                ('Average RPM', str(rpm_stats[2])),
                ('Max RPM', str(rpm_stats[1])),
                ('Average Altitude', altitude_stats[2]),
                ('Max Altitude', altitude_stats[1]),
                ('Min Altitude', altitude_stats[0])]
        i = 0
        for stat in self.labels:
            stat.set_label("%s: %s" % (stats[i][0], stats[i][1]))
            i += 1

    def __format_speed(self, speed_stats, metric):
        speeds = []
        for speed in speed_stats:
            if speed >= 0:
                if metric:
                    speeds.append(str(speed) + 'km/h')
                else:
                    speed = (speed * 62) / 100
                    speeds.append(str(speed) + 'MPH')
            else:
                speeds.append(None)
        return speeds

    def __format_distance(self, distance, metric):
        if metric:
            return "%.2f Km" % distance
        else:
            return "%.2f miles" % (distance * 0.621371192)

    def __update(self, *data):
        self.set_values(True)
