#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ManageBuddyDlgView}.
"""

import etk

from main.basedlgview import BaseDlgView
from main.mainview import MainView
from models.kbmodel import KeyBoardModel

class ManageBuddyDlgView(BaseDlgView):
    """
    Manage buddy dialog class. This class handles the viewer
    part of editing buddy info(alias).

    @type   title: string
    @param  title: Dialog title.
    @type   cb: callback
    @param  cb: Confirm callback.
    @type   return_cb: callback
    @param  return_cb: Cancel callback.
    @type   group_name: string
    @param  group_name: Name of the Edje group.
    """
    def __init__(self, title, cb, return_cb, group_name):
        canvas = MainView().get_evas_canvas()
        self.title = title
        self.group_name = group_name
        BaseDlgView.__init__(self, self.group_name, 30)
        self.part_text_set("title", self.title)

        self.alias_entry = etk.Entry()

        embed = etk.Embed(canvas)
        embed.add(self.alias_entry)
        self.alias_entry.on_key_down(self.__key_down)
        embed.show_all()
        self.part_swallow("display_label", embed.object)
        self.alias_entry.focus()

        self.cb = callable(cb) and cb or None
        self.cb_r = callable(return_cb) and return_cb or None
        self.signal_callback_add("hide", "", self.__destroy)
        self.signal_callback_add("confirm_bt_clicked", "", self.__confirm_cb)
        self.signal_callback_add("cancel_bt_clicked", "", self.__cancel_cb)

    def __key_down(self, obj, event):
        """
        Callback to handle keys pressed(ESC or Enter).

        @type   obj: object
        @param  obj: Not used.
        @type   event: EventKeyDown
        @param  event: Event key down object.

        @rtype: boolean
        @return: C{True}.
        """
        if event.key == "Escape":
            self.__cancel_cb()
        elif event.key == "Return" or event.key == "KP_Enter":
            self.__confirm_cb()
        return True

    def __confirm_cb(self, *data):
        """
        Called when the user selects the OK button.

        @type   data: L{ManageBuddyDlgView}
        @param  data: Not used.
        """
        if self.cb:
            self.cb(self)

    def __cancel_cb(self, *data):
        """
        Called when the user selects the Cancel button.

        @type   data: L{ManageBuddyDlgView}
        @param  data: Not used.
        """
        if self.cb_r:
            self.cb_r()
        self.hide()

    def __destroy(self, *data):
        """
        Called when the dialog is closed.

        @type   data: L{ManageBuddyDlgView}
        @param  data: Not used.
        """
        self.cb = None
        self.cb_r = None
        self.alias_entry.destroy()
        KeyBoardModel().set_focus()

