#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{PairingDlgView}.
"""

from basedlgview import BaseDlgView

class PairingDlgView(BaseDlgView):
    """
    Pairing dialog view.
    """

    def __init__(self):
        BaseDlgView.__init__(self, "pairing", 30)

    def display_set(self, value):
        """
        Displays the value typed.

        @type   value: int
        @param  value: Value typed.
        """
        self.part_text_set("display_label", value)

    def keyboard_connect_cbs(self, cbs):
        """
        Connects every digit (0-9) callback to its respective signal.

        @type   cbs: tuple
        @param  cbs: Tuple of 10 callbacks respective to each digit.
        """
        key = 0
        for cb in cbs:
            self.signal_callback_add(str(key)+"_bt_clicked", "", cb)
            key += 1

    def confirm_connect_cb(self, cb):
        """
        Connects the confirm callback to the signal 'confirm_bt_clicked'.

        @type   cb: callback
        @param  cb: Confirm callback.
        """
        self.signal_callback_add("confirm_bt_clicked", "", cb)

    def cancel_connect_cb(self, cb):
        """
        Connects the cancel callback to the signal 'cancel_bt_clicked'.

        @type   cb: callback
        @param  cb: Cancel callback.
        """
        self.signal_callback_add("cancel_bt_clicked", "", cb)

    def clear_connect_cb(self, cb):
        """
        Connects the clear callback to the signal 'clear_bt_clicked'.

        @type   cb: callback
        @param  cb: Clear callback.
        """
        self.signal_callback_add("clear_bt_clicked", "", cb)

