#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{EventView}.
"""

class EventView(object):
    """
    Common class to handle screen events.

    @type   canvas: L{evas.Canvas}
    @param  canvas: Evas canvas object.
    """
    def __init__(self, canvas):
        self.left_button = canvas.Rectangle(color=(0, 0, 0, 0),
            pos=(0, 80), size=(150, 320))
        self.left_button.layer_set(5)
        self.right_button = canvas.Rectangle(color=(0, 0, 0, 0),
            pos=(650, 80), size=(150, 320))
        self.right_button.layer_set(5)

    def set_previous_cb(self, cb):
        """
        Set previous screen callback.

        @type   cb: callback
        @param  cb: Function callback.
        """
        def button_cb(obj, event):
            self.previous_cb()

        if callable(cb):
            self.previous_cb = cb
            self.left_button.on_mouse_down_add(button_cb)

    def set_next_cb(self, cb):
        """
        Sets the next screen callback.

        @type   cb: callback
        @param  cb: function callback
        """
        def button_cb(obj, event):
            self.next_cb()

        if callable(cb):
            self.next_cb = cb
            self.right_button.on_mouse_down_add(button_cb)

    def show(self):
        """
        Displays controls (Right and Left buttons).
        """
        self.left_button.show()
        self.right_button.show()

    def hide(self):
        """
        Hide controls (Right and Left buttons).
        """
        self.left_button.hide()
        self.right_button.hide()

