#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.listctrl import ListView
from common.carmanconfig import CarmanConfig, METRIC, IMPERIAL

class UnitListView(ListView):

    def __init__(self, parent):
        self._parent = parent
        ListView.__init__(self, "list-normal", "list-item-checkbox",
            "CHANGE UNIT")

        unit = CarmanConfig().get_unit()
        self.add_item("Metric", self.__change_unit,
                METRIC, check=unit==METRIC)
        self.add_item("Imperial", self.__change_unit,
                IMPERIAL, check=unit==IMPERIAL)

    def __change_unit(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        self._parent._parent._parent.set_unit_system(param)
