#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.listctrl import ListView
from models.mapmodel import MapModel
from models.connmodel import ConnectionModel
from maps.tracklistview import TrackListView
from maps.downloadctrl import DownloadAreaController, DownloadTrackController

class ManageMaps(ListView):

    def __init__(self, parent):
        self._parent = parent
        self.map_model = MapModel()
        ListView.__init__(self, "list-normal", "list-item-normal",
                          "MANAGE MAPS")

        if not self._parent._parent.is_downloading():
            self.add_item("Clear map service cache",
                self.__clear_map_service_cache)
            if ConnectionModel().Status() == ConnectionModel.CONNECTED:
                self.add_item("Download maps by area",
                             self.__dwnl_maps_by_area)
#                self.add_item("Download maps by track",
#                             self.__dwnl_maps_by_track)
        else:
            self.add_item("Stop current download",
                self.__stop_current_download)

    def __stop_current_download(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        self._parent._parent.stop_download()

    def __clear_map_service_cache(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        self.map_model.clear_repository_files()

    def __dwnl_maps_by_area(self, obj, item, param):
        download = DownloadAreaController(self)
        download.show()

    """
    def __dwnl_maps_by_track(self, obj, item, param):
        def track_selected(obj, item, param):
            download = DownloadTrackController(obj, param)
            download.show()

        tracklist = TrackListView(self, False, track_selected)
        tracklist.show()
    """
