#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.listctrl import ListView
from main.messagedlgctrl import MessageDlgController

class BuddyListView(ListView):

    def __init__(self, parent):
        self._parent = parent
        ListView.__init__(self, "list-normal", "list-item-checkbox",
            "FOLLOW FRIEND")

    def set_buddies(self, buddies, buddies_connected):
        connected = []
        not_connected = []
        self.buddies_connected = buddies_connected

        for buddy in buddies:
            if buddy[1] in buddies_connected:
                connected.append(buddy)
            else:
                not_connected.append(buddy)

        for buddy in connected:
            self.add_item(buddy[0], None, check=True)
        for buddy in not_connected:
            self.add_item(buddy[0], self.__buddy_selected_cb, (buddy[0],
                buddy[1]), check=False)

    def __buddy_selected_cb(self, obj, item, param):
        def disconnect():
            self.hide()
            self._parent._parent.hide(True)
            for path in self.buddies_connected.values():
                self._parent._parent._parent.disconnect_buddy(path,
                    False)
            self._parent._parent._parent.request_authorization(*param)

        if not self.buddies_connected:
            self.hide()
            self._parent._parent.hide(True)
            self._parent._parent._parent.request_authorization(*param)
        else:
            msg = MessageDlgController(confirm_cb=disconnect)
            msg.show_message("You are already connected.<br>Do you want " \
                "disconnect from previous friend?", buttons=2,
                title="FOLLOW FRIEND")
