#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import DEBUG
from main.basedlgview import BaseDlgView
from models.obdmodel import OBDModel
from models.gpsmodel import GPSModel
from models.connmodel import ConnectionModel

class StatusView(BaseDlgView):

    def __init__(self, gps_cb, obd_cb, wlan_cb):
        BaseDlgView.__init__(self, "status")

        self.signal_callback_add("gps_bt-clicked", "", gps_cb)
        self.signal_callback_add("obd_bt-clicked", "", obd_cb)
        self.signal_callback_add("wlan_bt-clicked", "", wlan_cb)

    def __del__(self):
        DEBUG("deleting Status View %s" % self)

    def set_gps_status(self, status):
        if status == GPSModel.CONNECTING:
            self.signal_emit("gps-connecting", "")
        elif status == GPSModel.DISCONNECTED:
            self.signal_emit("gps-disconnected", "")
        elif status == GPSModel.FIXING:
            self.signal_emit("gps-fixing", "")
        elif status == GPSModel.FIXED:
            self.signal_emit("gps-fixed", "")

    def set_obd_status(self, status):
        if status == OBDModel.CONNECTED:
            self.signal_emit("obd-connected", "")
        elif status == OBDModel.CONNECTING:
            self.signal_emit("obd-connecting", "")
        elif status == OBDModel.DISCONNECTED:
            self.signal_emit("obd-disconnected", "")

    def set_wlan_status(self, status):
        if status == ConnectionModel.CONNECTED:
            self.signal_emit("wlan-connected", "")
        elif status == ConnectionModel.CONNECTING:
            self.signal_emit("wlan-connecting", "")
        elif status == ConnectionModel.IDLE:
            self.signal_emit("wlan-disconnected", "")
