#!/usr/bin/env python2.5

# carman.py - Main application
#
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, ecore
import common.ossohelper as osso
from common.carmanconfig import CarmanConfig
from main.mainview import MainView

class Main(object):

    def __init__(self):
        osso.application_init("carman_evas")
        osso.display_on()
        if osso.has_osso():
            ecore.timer_add(45, self.__display_blanking)
        config = CarmanConfig()
        theme = config.get_current_theme()
        if not os.path.exists(theme):
            path = os.path.join(config.get_theme_root_path(), "tuning")
            config.set_theme_path(path)
            theme = config.get_current_theme()
        self.view = MainView()
        self.view.show_splashscreen(theme)
        ecore.idler_add(self.process)
        ecore.main_loop_begin()
        self.main.finalize()
        osso.application_exit()
    # __init__()

    def process(self):
        from main.mainctrl import MainController
        self.main = MainController(self.view)
        self.view.hide_splashscreen()
        return False
    # process()

    def __display_blanking(self):
        osso.display_blanking_pause()
        return True
    # __display_blanking
