# util.py - Utility functions
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

from common.carlog import WARNING

def merge_dicts(dict1, dict2):
    dict = {}
    for key, value in dict1.items():
        dict[key.lower()] = value
    for key, value in dict2.items():
        dict[key.lower()] = value

    return dict

def conv_color(color):
    try:
        return (int(color[:2], 16), int(color[2:4], 16), int(color[4:], 16))
    except:
        WARNING("color '%s' invalid !!!" % color)
        return (255, 255, 255)

def get_param(dict, id, value_default):
    try:
        return dict[id]
    except:
        WARNING("key '%s' not found !!!" % id)
        return value_default

def get_param_int(dict, id, value_default):
    try:
        return int(float(dict[id]))
    except ValueError:
        WARNING("error converting %s to integer" % dict[id])
        return value_default
    except KeyError:
        WARNING("key %s not found !!!" % id)
        return value_default

def conv_to_unicode(text):
    if not isinstance(text, unicode):
        return unicode(text, "utf-8")

    return text

def rect_intersection(rect, rects):
    w = rect[0] + rect[2]
    h = rect[1] + rect[3]
    for r in rects:
        if r[0] + r[2] > rect[0] and w > r[0] and \
          r[1] + r[3] > rect[1] and h > r[1]:
            return True
    return False
