#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

__THRESHOLD__ = 5

import evas

class EventView(evas.SmartObject):

    def __init__(self, canvas, controller):
        evas.SmartObject.__init__(self, canvas)
        self.dragged = False
        self.button_down = False
        self.controller = controller
        self.area = self.Rectangle(color=(0, 0, 0, 0))
        self.area.on_mouse_move_add(self.__on_mouse_move)
        self.area.on_mouse_down_add(self.__on_mouse_down)
        self.area.on_mouse_up_add(self.__on_mouse_up)

    def __on_mouse_move(self, obj, event):
        if self.button_down:
            dx = event.position.output.x - self.prev_position_x
            if abs(dx) > __THRESHOLD__:
                self.dragged = True
                self.prev_position_x = event.position.output.x
                x =  event.position.output.x - self.prev
                self.controller.move(dx)

    def __on_mouse_down(self, obj, event):
        self.dragged = False
        self.button_down = True
        self.prev_position_x = self.prev = event.position.output.x

    def __on_mouse_up(self, obj, event):
        if self.button_down:
            if self.dragged:
                self.controller.end_move()
        self.button_down = False

    def resize(self, w, h):
        self.w = w
        self.h = h
        self.area.resize(w, h)

    def clip_set(self, obj):
        self.area.clip_set(obj)

    def clip_unset(self):
        self.area.clip_unset()

    def show(self):
        self.area.show()

    def hide(self):
        self.area.hide()
