#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import shutil
from common.carlog import DEBUG
from models.tripsmodel import TripsModel
from trips.triplistview import TripListView
from main.messagedlgctrl import MessageDlgController

class DeleteTripController(object):

    def __init__(self, parent):
        self._parent = parent
        self.trips_model = TripsModel()

    def __del__(self):
       DEBUG("deleting DeleteTripController %s" % self)

    def show(self):
        self.trip_loaded = self._parent._parent._parent.get_loaded_trip()
        view = TripListView("DELETE TRIP", self.__delete_trip_cb)
        if view.is_empty():
            view.hide(True)
            msg = MessageDlgController()
            msg.show_message("No trips saved", title="DELETE TRIP")
        else:
            view.show()

    def __delete_trip_cb(self, obj, item, param):
        def delete_trip():
            shutil.rmtree(param)
            obj.remove_item(item)
            if not obj.has_items():
                obj.hide(True)

        if self.trip_loaded == param:
            msg = MessageDlgController()
            msg.show_message("Could not delete loaded trip",
                title="DELETE TRIP")
        else:
            name = self.trips_model.get_trip_info(param)[0]
            msg = MessageDlgController(confirm_cb=delete_trip)
            msg.show_message("Do you really want to delete %s this trip?" % name,
                    buttons=2, title="DELETE TRIP")
