#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.basedlgview import BaseDlgView

class MessageDlgView(BaseDlgView):

    def __init__(self):
        BaseDlgView.__init__(self, "message", 30)

    def show_message(self, msg, confirm_msg, cancel_msg):
        self.part_text_set("msg_label", msg)
        if confirm_msg:
            self.set_confirm_label(confirm_msg)
        if cancel_msg:
            self.set_cancel_label(cancel_msg)
        self.show()

    def set_buttons(self, two=True):
        if two:
            self.signal_emit("two-buttons", "");

    def set_title(self, title):
        self.part_text_set("title", title)

    def set_confirm_label(self, msg):
        self.part_text_set("confirm_bt_label", msg)

    def set_cancel_label(self, msg):
        self.part_text_set("cancel_bt_label", msg)

    def confirm_connect_cb(self, confirm_cb, confirm_msg=None):
        if confirm_msg:
            self.set_confirm_label(confirm_msg)

        self.signal_callback_add("confirm_bt_clicked", "", confirm_cb)

    def cancel_connect_cb(self, cancel_cb, cancel_msg=None):
        if cancel_msg:
            self.set_cancel_label(cancel_msg)

        self.signal_callback_add("cancel_bt_clicked", "", cancel_cb)

