#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import DEBUG
from models.kbmodel import KeyBoardModel
from main.messagedlgview import MessageDlgView

class MessageDlgController(object):

    def __init__(self, confirm_cb=None, cancel_cb=None):
        self._confirm_cb = confirm_cb
        self._cancel_cb = cancel_cb

        self.view = MessageDlgView()
        self.view.confirm_connect_cb(self.confirm_cb)
        self.view.cancel_connect_cb(self.cancel_cb)

        self.kb_model = KeyBoardModel()
        self.kb_model.add_key_down_cb(self.__key_down_cb)

    def __del__(self):
        DEBUG("deleting MessageDlgController %s" % self)

    def __key_down_cb(self, obj, event):
        if event.key == "Return" or event.key == "space" or \
                                    event.key == "KP_Enter":
            self.confirm_cb()
            return True
        elif event.key == "Escape":
            self.cancel_cb()
            return True

        return False

    def show_message(self, msg, buttons=1, title=None, confirm_msg=None,\
            cancel_msg=None):
        if buttons == 2:
            self.view.set_buttons()
        if title:
            self.view.set_title(title)
        self.view.show_message(msg, confirm_msg, cancel_msg)

    def confirm_cb(self, *data):
        self.view.hide()
        if callable(self._confirm_cb):
            self._confirm_cb()
        self._confirm_cb = None
        self._cancel_cb = None
        self.kb_model.del_key_down_cb(self.__key_down_cb)

    def cancel_cb(self, *data):
        self.view.hide()
        if callable(self._cancel_cb):
            self._cancel_cb()
        self._confirm_cb = None
        self._cancel_cb = None
        self.kb_model.del_key_down_cb(self.__key_down_cb)
