#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import etk
from common.carlog import DEBUG
from main.mainview import MainView
from main.basedlgview import BaseDlgView
from models.kbmodel import KeyBoardModel

class EditDlgView(BaseDlgView):

    def __init__(self, title, message, text, cb):
        canvas = MainView().get_evas_canvas()
        BaseDlgView.__init__(self, "managedlg", 30)
        self.part_text_set("label", message)
        self.part_text_set("title", title)

        self.entry = etk.Entry()
        self.entry.text = self.actual_name = text.strip()
        embed = etk.Embed(canvas)
        embed.add(self.entry)
        self.entry.on_unfocused(self.focus_out_cb)
        self.entry.on_key_down(self.__key_down)
        embed.show_all()
        self.part_swallow("display_label", embed.object)
        self.entry.focus()

        self.cb = callable(cb) and cb or None
        self.signal_callback_add("hide", "", self.__destroy)
        self.signal_callback_add("confirm_bt_clicked", "", self.__confirm_cb)
        self.signal_callback_add("cancel_bt_clicked", "", self.__cancel_cb)

    def __del__(self):
       DEBUG("deleting EditDlgView %s" % self)

    def focus_out_cb(self, obj):
        self.entry.focus()

    def __key_down(self, obj, event):
        if event.key == "Escape":
            self.__cancel_cb()
        elif event.key == "Return" or event.key == "KP_Enter":
            self.__confirm_cb()
        return True

    def __confirm_cb(self, *data):
        name = self.entry.text_get().strip()
        if self.cb:
            self.cb(self, name)

    def __cancel_cb(self, *date):
        self.hide()

    def __destroy(self, *data):
        self.entry.disconnect(self.entry.UNFOCUSED_SIGNAL, self.focus_out_cb)
        self.entry.destroy()
        KeyBoardModel().set_focus()
