#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from common.carlog import DEBUG

class DigitalView(object):

    def __init__(self, screen, part_name, round=0, has_unit="no"):
        """
        Gauge Digital constructor
        @param screen: Edje group object
        @param part_name: Edje text part name
        @param round: number to round precision in decimal digits
        @param has_unit: Show value with unit
        """
        self.unit = ""
        self.last_value = 0
        self.screen = screen
        self.part_name = part_name
        self.round = round >= 0 and round or 0
        self.has_unit = has_unit.lower() == "yes"
        self.set_value(0, 0)

    def __del__(self):
        DEBUG("deleting digital gauge %s" % self)

    def set_value(self, value_abs, value_rel):
        """
        Change current value
        @param value_abs: absolute value to show
        @param value_rel: relative value (not used)
        """
        self.last_value = value_abs
        value = ("%%.%df" % self.round) % value_abs
        if self.has_unit:
            value += "<unit>" + self.unit + "</unit>"
        self.screen.part_text_set(self.part_name, value.encode("utf-8"))

    def set_unit_system(self, min, max, scale, unit):
        """
        Change unit system values
        @param min: integer mininum value
        @param max: integer maximum value
        @param scale: integer scale value
        @param unit: string unit value
        """
        if self.has_unit:
            self.unit = unit
            self.set_value(self.last_value, 0)

