#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

__LABELS__ = 7
__SLABELS__ = 4

import evas, edje, datetime

class ZoomView(evas.SmartObject):

    def __init__(self, canvas, controller):
        evas.SmartObject.__init__(self, canvas)
        self.controller = controller
        self.theme = None
        self.labels = []
        self.nlabel = __LABELS__
        self.clip_rect = self.Rectangle()
        for i in range(self.nlabel):
            label = self.Text()
            label.clip_set(self.clip_rect)
            label.show()
            rect = self.Rectangle()
            rect.resize(2, 15)
            rect.clip_set(self.clip_rect)
            rect.show()
            self.labels.append((label, rect))

    def set_theme(self, theme):
        self.theme = theme
        color = edje.file_data_get(theme, "trips:font-color")
        label_color = [(int(x)) for x in color.split(":")]
        color = edje.file_data_get(theme, "trips:guide-color")
        rect_color = [(int(x)) for x in color.split(":")]
        rect_color = evas.color_argb_premul(*rect_color)
        self.font_type = "fonts/%s" % edje.file_data_get(theme, "trips:font")
        self.font_size = int(edje.file_data_get(theme, "trips:font-size"))
        for label, rect in self.labels:
            label.color_set(*label_color)
            label.font_source_set(theme)
            label.font_set(self.font_type, self.font_size)
            rect.color_set(*rect_color)

    def update_times(self, start, zoom):
        self.start = start
        self.zoom = zoom
        self.changed()

    def calculate(self):
        inner_t = self.zoom / (self.nlabel - 1)
        inner_w = self.w / (self.nlabel - 1)
        mod = self.start % inner_t
        time_label = self.start + (inner_t - mod) - inner_t
        label_x = (int((float(self.start % inner_t) / self.zoom) * \
            self.w) * -1) -1

        for label, rect in self.labels:
            text = str(datetime.timedelta(0, time_label))[:-3]
            label.text_set(text)
            label.move(self.pos[0]+ 5 + label_x, self.pos[1] )
            rect.move(self.pos[0] + label_x, self.pos[1])
            time_label += inner_t
            label_x += inner_w

    def split_screen(self, splited):
        self.nlabel = __SLABELS__ if splited else __LABELS__

    def resize(self, w, h):
        self.w = w
        self.h = h
        self.clip_rect.resize(w, h)

    def clip_set(self, obj):
        self.clip_rect.clip_set(obj)

    def clip_unset(self):
        self.clip_rect.clip_unset()

    def show(self):
        self.clip_rect.show()

    def hide(self):
        self.clip_rect.hide()
