#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


import sys, os, gdbm, ConfigParser

from glob import glob
from distutils.core import setup, Extension
from distutils.dist import Distribution
from distutils.cmd import Command
from distutils.command.build import build
from distutils.command.install import install
from distutils.dep_util import newer
from distutils.util import convert_path
from subprocess import Popen, PIPE

cflags = Popen(['pkg-config', '--cflags', 'evas'], stdout=PIPE).communicate()[0].split()
ldflags = Popen(['pkg-config', '--libs', 'evas'], stdout=PIPE).communicate()[0].split()

def dtc_db_filename(full_name):
    filename = os.path.basename(full_name)
    return os.path.splitext(filename)[0] + '.db'
# dtc_db_filename

class carman_dist(Distribution):

    def __init__(self, attrs=None):
        self.dtc_files= None
#        self.profile_files = None
        Distribution.__init__(self,attrs)
    # __init__

    def has_dtc_files (self):
        return self.dtc_files and len(self.dtc_files) > 0
    # has_dtc_files

#    def has_profile(self):
#        return self.profile_files and len(self.profile_files) > 0
    # has_dtc_files
# carman_dist

class carman_build(build):

    def has_dtcs(self):
        return self.distribution.has_dtc_files()
    # has_dtcs

#    def has_profiles(self):
#        return self.distribution.has_profile()
    # has_profile

    build.sub_commands.append(('build_dtcs', has_dtcs))
#    build.sub_commands.append(('build_profiledb', has_profiles))
# carman_build

class build_dtcs(Command):

    description = "\"build\" dtc gdbm database (copy to build directory)"

    user_options = [
        ('build-base=', 'd', "directory to \"build\" (copy) to"),
        ('force', 'f', "forcibly build everything (ignore file timestamps"),
        ]

    boolean_options = ['force']

    def initialize_options (self):
        self.dtc_files = None
        self.force = None
        self.build_base = None
        self.build_dtcs = None
    # initialize_options

    def finalize_options (self):
        self.set_undefined_options('build',
                                  ('force', 'force'),
                                  ('build_base','build_base'))
        self.dtc_files = self.distribution.dtc_files
        self.build_dtcs = os.path.join(self.build_base, 'dtcs')
    # finalize_options


    def run (self):
        if not self.dtc_files:
            return
        print "building dtc"
        self.build_dtcs_db()
    # run

    def build_dtcs_db(self):

        def create_dtc_db(infile, outfile):

            cfg = ConfigParser.ConfigParser()
            cfg.optionxform = str
            cfg.read([infile, ])

            dir = os.path.dirname(outfile)
            self.mkpath(dir)

            db = gdbm.open(outfile, 'n')

            for key in cfg.options('dtcs') :
                db[key] = cfg.get('dtcs', key)

            db.sync()
            db.close()
        # create_dtc_db

        for in_file, inst_dest in self.dtc_files:
            builtfile = os.path.join(self.build_dtcs, dtc_db_filename(in_file))
            if not self.force and not newer(in_file, builtfile):
                self.announce("not building %s (up-to-date)" % in_file)
                continue
            create_dtc_db(in_file, builtfile)
    # build_dtcs_db
# build_dtc

setup(name='carman-evas',
      version='0.7',
      description='carman rich view package',
      long_description='carman rich view (EVAS based) package',
      url='http://www.indt.org.br',
      scripts=['carman-evas'],
      packages=['main', 'models', 'gauges', 'maps', 'trips', 'plugins',
                'themes.modules', 'models.plugins', 'options','common',
		'common.dbus_bt'],
      ext_modules=[Extension(name='main.evasutil',
                    sources=['main/evasutil.c'], libraries=['evas'],
                    extra_compile_args=cflags, extra_link_args=ldflags),
                   Extension(name='main.trip', sources=['main/trip.c'],
                       extra_compile_args=cflags, extra_link_args=ldflags)],
    dtc_files = [('data/dtcs.in',
                  'share/carman'), ],
    distclass = carman_dist,
    cmdclass = {'build_dtcs': build_dtcs}
)
