#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python
#  
#  carman-python is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of the
#  License, or (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program. If not, see <http://www.gnu.org/licenses/>.
#


import pygst, gst, time, dbus
from os import path
from common.carmanconfig import CarmanConfig
from common.carlog import ERROR

__SOUND_FILE__ = "alert.mp3"

class SoundController(object):

    def __init__(self):
        self.player = gst.element_factory_make("playbin", "player")
        self.__snd_time = 0

    def _play_alert(self):
        if time.time() - self.__snd_time < 2:
            return
        self.__snd_time = time.time()
        try:
            themepath = CarmanConfig().get_current_theme_path()
        except dbus.exceptions.DBusException, err:
            ERROR("Error in get current theme path: %s" % err)
            return

        sound_file = "file://"+path.join(themepath, __SOUND_FILE__)
        try:
            self.player.set_state(gst.STATE_READY)
            self.player.set_property('uri', sound_file)
            self.player.set_property('volume', 10.0)
            self.player.set_state(gst.STATE_PLAYING)
        except:
            ERROR("Error playing sound alert sound!")

