#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import ecore, dbus, dbus.service
from common.carlog import DEBUG
from models.dbusmodel import CarmandDbusModel
from main.messagedlgctrl import MessageDlgController

TIMEOUT             = 30
AGENT_BUS_NAME      = "org.indt.carmanplugin.Agent"
AGENT_OBJECT_PATH   = "/carman/agent"

class InfoSharingAgent(dbus.service.Object):

    def __init__(self):
        bus = CarmandDbusModel().get_bus()
        dbus.service.Object.__init__(self, bus, AGENT_OBJECT_PATH)

    def __authorized(self):
        self.msg = None
        self.timer.delete()
        self._reply_ok()

    def __rejected(self):
        self.msg = None
        self.timer.delete()
        self._reply_error(dbus.DBusException(
            "org.indt.carmanplugin.Agent.Error.Rejected"))

    def __timeout(self):
        self.msg.cancel_cb()

    @dbus.service.method(AGENT_BUS_NAME, in_signature="ss", out_signature="",
        async_callbacks=('reply_ok', 'reply_error'))
    def Authorize(self, email, name, reply_ok, reply_error):
        self._reply_ok = reply_ok
        self._reply_error = reply_error
        self.msg = MessageDlgController(confirm_cb=self.__authorized,
            cancel_cb=self.__rejected)
        self.msg.show_message("%s wants to share Carman Information.<br>" \
            "Do you accept?" % name, title="FOLLOW FRIEND", buttons=2)
        self.timer = ecore.timer_add(TIMEOUT, self.__timeout)

    @dbus.service.method(AGENT_BUS_NAME, in_signature="", out_signature="")
    def Release(self):
        DEBUG("Agent released")
