#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, sys, glob
from common.carlog import ERROR

class Controller(object):
    """
    The base controller class.
    """
    NAME = "Dummy"

    def get_name(self):
        """ """
        return self.NAME
    # get_name

    def key_down_cb(self, obj, event):
        pass
    # key_down_cb

    def set_unit_system(self, value):
        pass
    # set_unit_system

    def show_options(self):
        pass
    # show_options

    def device_connected(self, obd):
        pass
    # device_connected

    def activate(self):
        pass
    # activate

    def deactivate(self):
        pass
    # deactivate

    def get_view(self):
        pass
    # get_view

    def get_icon(self):
        pass
    # get_icon

    def set_theme(self, theme):
        pass
    # set_theme

    def finalize(self):
        pass
    # finalize
# Controller

class ContainerController(object):
    """
    The controller that will load all the plugins and options.
    """
    def __init__(self, parent, canvas, theme):
        """ """
        self._parent = parent
        self._canvas = canvas
        self._theme = theme
    # __init__

    def __load_module(self, path, name):
        try:
            module = __import__(os.path.join(path, name))
            container = module.get_container(self._parent, self._canvas,
                self._theme)
            if isinstance(container, Controller):
                return container
            else:
                DEBUG("Container %s invalid for maps" % name)
        except Exception, e:
            ERROR("error opening container %s: %s" % (name, e))

    def load_containers(self, path):
        containers = []
        list_aux = ["__init__"]

        files = glob.glob(os.path.join(path, "*.py*"))
        files.sort()
        for plugin in files:
            name = os.path.basename(plugin).rsplit('.', 1)[0]

            if name in list_aux:
                continue
            list_aux.append(name)

            container = self.__load_module(path, name)
            if container is not None:
                containers.append(container)

        return containers

# ContainerController
