#!/usr/bin/env python
# -*- coding: UTF8 -*-
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

class SingletonMeta(type):

    def __init__(mcs, name, base, dic):
        super(SingletonMeta, mcs).__init__(mcs, name, base, dic)
        mcs.__instance = None
        mcs.__copy__ = lambda self: self
        mcs.__deepcopy__ = lambda self, memo=None: self
    # __init__

    def __call__(cls, *args, **kwargs):
        if not cls.__instance:
            cls.__instance = super(SingletonMeta, cls).__call__(*args, **kwargs)
        return cls.__instance
    # __call__
# SingletonMeta

class Singleton(object):
    __metaclass__ = SingletonMeta
    pass
# Singleton
