#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from options.globaloptview import GlobalOptionsView
from trips.changegraph import ChangeGraph
from trips.loadtripctrl import LoadTripController
from trips.managetrips import ManageTrips

class OptionController(object):

    def __init__(self, parent):
        """
        Controller Constructor
        @param parent: Parent Controller
        """
        self._parent = parent

    def show(self):
        view = GlobalOptionsView(self._parent)
        view.add_item("Load trip", self.__load_trip)
        view.add_item("Change graphic", self.__change_graphic)
        view.add_item("Manage trips", self.__manage_trips)
        view.add_global_items()
        view.show()

    def __change_graphic(self, obj, item, param):
        change = ChangeGraph(obj)
        change.show()

    def __load_trip(self, obj, item, param):
        load = LoadTripController(obj)
        load.show()

    def __manage_trips(self, obj, item, param):
        mng = ManageTrips(obj)
        mng.show()
