#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import evas

class ProgressBarView(evas.SmartObject):

    def __init__(self, canvas):
        evas.SmartObject.__init__(self, canvas)
        self.x = self.y = 0
        self.last_width = -1
        self.clipper = self.Rectangle(size=(0, 0))
        self.progressbar = self.Image()
        self.progressbar.clip_set(self.clipper)
        self.clipper.show()

    def set_theme(self, theme):
        self.progressbar.file_set(theme, "images/download-bar-full")
        self.sx, self.sy = self.progressbar.image_size_get()
        self.progressbar.size_set(self.sx, self.sy)
        self.progressbar.fill_set(0, 0, self.sx, self.sy)
        self.progressbar.show()

    def clip_set(self, obj):
        self.clipper.clip_set(obj)

    def clip_unset(self):
        self.clipper.clip_unset()

    def show(self):
        self.clipper.show()

    def hide(self):
        self.clipper.hide()

    def move(self, x, y):
        self.clipper.move(x - self.sx / 2, y - self.sy / 2)
        self.progressbar.move(x - self.sx / 2, y - self.sy / 2)

    def resize(self, w, h):
        pass

    def update(self, pos):
        width = int(round(pos * self.sx))
        if width != self.last_width:
            self.last_width = width
            self.clipper.size_set(width, self.sy)
